package com.qiho.center.biz.service.impl;

import java.util.Date;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import org.apache.commons.lang.time.DateFormatUtils;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.stereotype.Service;

import com.alibaba.dubbo.common.utils.StringUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qiho.center.biz.service.ItemDaySaleService;
import com.qiho.center.biz.service.ItemSaleCountService;
import com.qiho.center.biz.service.order.OrderSnapshotService;

import cn.com.duiba.wolf.utils.DateUtils;

/**
 * Created by qianjue on 2017/9/14.
 */
@Service
public class ItemSaleCountServiceImpl implements ItemSaleCountService {

    @Resource(name = "stringRedisTemplate")
    private HashOperations<String, String, String> ops;

    @Resource
    private OrderSnapshotService orderSnapshotService;

    @Resource
    private ItemDaySaleService itemDaySaleService;

    public static final String ITEM_SALE_NUM_COUNT = "QIHO_ITEM_SALENUM";

    @Override
    public void syncItemHistorySaleNum() {
        Date endTime = DateUtils.getStartTime(new Date());
        Map<Long, Integer> map = orderSnapshotService.queryItemSaleCountBatch(Lists.newArrayList(), null, endTime);
        if (null == map) {
            return;
        }
        for (Map.Entry<Long, Integer> t : map.entrySet()) {
            ops.put(ITEM_SALE_NUM_COUNT, t.getKey() + "", t.getValue() + "");
        }
        //缓存过期时间设置为当日23:59:59
        ops.getOperations().expireAt(ITEM_SALE_NUM_COUNT, DateUtils.getEndTime(new Date()));
    }

    @Override
    public void newSyncItemHistorySaleNum() {
        List<Long> itemIdList = Lists.newArrayList();
        Date endTime = DateUtils.getStartTime(new Date());
        Map<Long, Long> map = itemDaySaleService.queryItemSaleCountBatch(itemIdList, null, endTime);
        if (null == map) {
            return;
        }
        for (Map.Entry<Long, Long> t : map.entrySet()) {
            ops.put(ITEM_SALE_NUM_COUNT, t.getKey() + "", t.getValue() + "");
        }
        //缓存过期时间设置为当日23:59:59
        ops.getOperations().expireAt(ITEM_SALE_NUM_COUNT, DateUtils.getEndTime(new Date()));
    }

    @Override
    public Map<Long, Integer> queryItemSaleNum(List<Long> itemIdList) {
        Map<Long, Integer> hisStoryMap = Maps.newHashMap();

        Map<String, String> history = ops.entries(ITEM_SALE_NUM_COUNT);
        //现将所有的初始数量设置为0
        itemIdList.stream().forEach(itemId -> {
            String itemIdStr = itemId.toString();
            String result = history.get(itemIdStr);
            Integer historyNum = StringUtils.isBlank(result) ? null : Integer.valueOf(result);
            if (null == historyNum) {
                historyNum = orderSnapshotService.queryItemSaleCount(itemId, null, DateUtils.getStartTime(new Date()));
                ops.put(ITEM_SALE_NUM_COUNT, itemIdStr, historyNum.toString());
                //由于预发线上公用redis缓存且预发环境定时任务不执行,为防止缓存数据不准确,缓存过期时间设置为当日23:59:59
                ops.getOperations().expireAt(ITEM_SALE_NUM_COUNT, DateUtils.getEndTime(new Date()));
            }
            hisStoryMap.put(itemId, historyNum);
        });
        Map<Long, Integer> map = orderSnapshotService
            .queryItemSaleCountBatch(itemIdList, DateUtils.getStartTime(new Date()), null);
        for (Map.Entry<Long, Integer> t : map.entrySet()) {
            map.put(t.getKey(), t.getValue() + hisStoryMap.get(t.getKey()));
        }
        return map;
    }

    public static void main(String[] args) {
        Date endTime = DateUtils.getStartTime(new Date());
        System.err.println(DateFormatUtils.format(endTime, "yyyy-MM-dd HH:mm:ss.SSS"));
    }

}
