package com.qiho.center.biz.service.impl.advert;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.advert.ItemAdvertPlanDto;
import com.qiho.center.api.dto.advert.TuiaPlanDto;
import com.qiho.center.api.params.advert.ItemBindPlanParams;
import com.qiho.center.api.params.advert.ItemPlanQueryParams;
import com.qiho.center.biz.service.advert.ItemPlanService;
import com.qiho.center.common.dao.QihoItemDAO;
import com.qiho.center.common.dao.QihoItemMerchantDAO;
import com.qiho.center.common.daoh.qiho.advert.BaiqiItemPlanMapper;
import com.qiho.center.common.daoh.qiho.advert.BaiqiMerchantLinkRelationMapper;
import com.qiho.center.common.daoh.qiho.advert.BaiqiTuiaPlanMapper;
import com.qiho.center.common.entity.item.QihoItemDetailEntity;
import com.qiho.center.common.entity.item.QihoItemEntity;
import com.qiho.center.common.entity.merchant.QihoItemMerchantEntity;
import com.qiho.center.common.entityd.qiho.advert.BaiqiItemPlanEntity;
import com.qiho.center.common.entityd.qiho.advert.BaiqiMerchantLinkRelationEntity;
import com.qiho.center.common.entityd.qiho.advert.BaiqiTuiaPlanEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @author chensong
 * @create 2018-01-05 11:37
 **/
@Service
public class ItemPlanServiceImpl implements ItemPlanService {

    @Autowired
    private BaiqiItemPlanMapper baiqiItemPlanMapper;

    @Autowired
    private QihoItemDAO qihoItemDAO;

    @Autowired
    private BaiqiTuiaPlanMapper baiqiTuiaPlanMapper;

    @Autowired
    private QihoItemMerchantDAO qihoItemMerchantDAO;

    @Autowired
    private BaiqiMerchantLinkRelationMapper baiqiMerchantLinkRelationMapper;


    @Override
    public PagenationDto<ItemAdvertPlanDto> queryPage(ItemPlanQueryParams params) {
        PagenationDto page = new PagenationDto();
        // 在商品表找出相应数据
        QihoItemEntity qihoItemEntity = new QihoItemEntity();
        qihoItemEntity.setId(params.getItemId());
        qihoItemEntity.setItemName(params.getItemName());
        Integer count = qihoItemDAO.countByParam(qihoItemEntity);
        page.setTotal(count);
        if (count.intValue() == 0) {
            page.setList(Lists.newArrayList());
            return page;
        }
        List<QihoItemDetailEntity> itemEntities = qihoItemDAO.queryByParam(qihoItemEntity, params.getPageNum(), params.getPageSize());
        // 获取商品id
        List<Long> itemIds = itemEntities.stream().map(QihoItemDetailEntity::getId).collect(Collectors.toList());

        // 在商品与广告计划的关联表找到对应广告计划id, 广告计划名称
        List<BaiqiItemPlanEntity> itemPlanEntities = baiqiItemPlanMapper.findByList(itemIds);
        // 用于存放商品id - 广告计划列表
        Map<Long, List<TuiaPlanDto>> advertMap = Maps.newHashMap();
        for (BaiqiItemPlanEntity entity : itemPlanEntities) {
            if (Objects.equals(null, advertMap.get(entity.getItemId()))) {
                TuiaPlanDto tuiaPlanDto = BeanUtils.copy(entity, TuiaPlanDto.class);
                advertMap.put(entity.getItemId(), Lists.newArrayList(tuiaPlanDto));
            } else {
                List<TuiaPlanDto> tuiaPlanDtos = advertMap.get(entity.getItemId());
                tuiaPlanDtos.add(BeanUtils.copy(entity, TuiaPlanDto.class));
                advertMap.put(entity.getItemId(), tuiaPlanDtos);
            }
        }

        // 获取商品所属商家是否关联广告主
        Map<Long, Boolean> itemAdvert = validAdvert(itemIds);

        // 类型转换
        List<ItemAdvertPlanDto> list = Lists.transform(itemEntities, itemEntitie -> {
            ItemAdvertPlanDto itemAdvertPlanDto = new ItemAdvertPlanDto();
            itemAdvertPlanDto.setItemId(itemEntitie.getId());
            itemAdvertPlanDto.setItemName(itemEntitie.getItemName());
            itemAdvertPlanDto.setAdvertList(advertMap.get(itemEntitie.getId()) == null
                    ? Lists.newArrayList(): advertMap.get(itemEntitie.getId()));
            itemAdvertPlanDto.setBindAdvert(itemAdvert.get(itemEntitie.getId()));
            return itemAdvertPlanDto;
        });
        page.setList(list);

        return page;
    }

    /**
     * 校验商品所属商家是否关联广告主
     * @return 商品id-是否关联广告主 true-是  false-否
     */
    private Map<Long, Boolean> validAdvert(List<Long> itemIds){
        // 获取商品-商家对应关系
        List<QihoItemMerchantEntity> itemMerchantEntities = qihoItemMerchantDAO.findByItemIds(itemIds);
        Map<Long, Long> map1 = Maps.newHashMap();  // 存放数据类型  商品id - 商家id
        itemMerchantEntities.stream().forEach(e -> {map1.put(e.getItemId(), e.getMerchantId());});

        // 获取商家-广告主是否绑定
        Map<Long, Long> map2 = Maps.newHashMap();  // 商家id-广告主id
        List<Long> merchantIds = Lists.newArrayList(map1.values());
        List<BaiqiMerchantLinkRelationEntity> relationEntityList = baiqiMerchantLinkRelationMapper.findBymerchantIds(merchantIds);
        relationEntityList.stream().forEach(e -> {map2.put(e.getMerchantId(), e.getRelationId());});

        // 将两个map对应关系整理
        Map<Long, Boolean> map3 = Maps.newHashMap();
        for (Long itemId : itemIds) {
            map3.put(itemId, map2.get(map1.get(itemId)) != null);
        }
        return map3;
    }

    @Override
    public List<TuiaPlanDto> getUnbindPlan(Long itemId) {
        BaiqiMerchantLinkRelationEntity relationEntity = getLinkRelation(itemId);
        if (Objects.equals(null, relationEntity)) {
            return Lists.newArrayList();
        }
        // 获取广告主id 在广告计划表查未关联的广告计划
        Long advertId = relationEntity.getRelationId();
        List<BaiqiTuiaPlanEntity> tuiaPlanEntities = baiqiTuiaPlanMapper.findUnbindPlan(advertId);

        return BeanUtils.copyList(tuiaPlanEntities, TuiaPlanDto.class);
    }

    @Override
    public Boolean bingPlan(ItemBindPlanParams params) throws BizException {
        // 校验商家是否关联广告主
        BaiqiMerchantLinkRelationEntity relationEntity = getLinkRelation(params.getItemId());
        if (Objects.equals(null, relationEntity)) {
            throw new BizException("商家未关联广告主");
        }
        // 校验广告计划是否均未关联
        List<Long> planIds = params.getPlanList();
        List<BaiqiItemPlanEntity> itemPlanEntities = baiqiItemPlanMapper.findByPlanIds(planIds); // 已经关联的广告计划
        if (itemPlanEntities.size() == planIds.size()) {
            throw new BizException("所有的广告计划都已被关联");
        }
        if (!CollectionUtils.isEmpty(itemPlanEntities)) {
            List<Long> bindPlanIds = itemPlanEntities.stream().map(BaiqiItemPlanEntity::getPlanId).collect(Collectors.toList());
            planIds.removeAll(bindPlanIds);
        }
        // 开始批量插入数据
        List<BaiqiItemPlanEntity> entityList = Lists.transform(planIds, e -> {
            BaiqiItemPlanEntity baiqiItemPlanEntity = new BaiqiItemPlanEntity();
            baiqiItemPlanEntity.setItemId(params.getItemId());
            baiqiItemPlanEntity.setPlanId(e);
            baiqiItemPlanEntity.setCreater(params.getCreater());
            baiqiItemPlanEntity.setModifier(params.getModifier());
            return baiqiItemPlanEntity;
        });
        Integer result = baiqiItemPlanMapper.insertBatch(entityList);

        return result.intValue() == entityList.size();
    }

    /**
     * 获取广告主id
     * @param itemId
     * @return
     */
    private BaiqiMerchantLinkRelationEntity getLinkRelation(Long itemId){
        // 获取到商家id
        Long merchantId = qihoItemMerchantDAO.findByItemId(itemId).getMerchantId();
        // 获取广告主id 目前只有tuia 关联类型为1
        BaiqiMerchantLinkRelationEntity merchantRelationEntity = new BaiqiMerchantLinkRelationEntity();
        merchantRelationEntity.setMerchantId(merchantId);
        merchantRelationEntity.setRelationType(1);
        return baiqiMerchantLinkRelationMapper.findByMerchantId(merchantRelationEntity);
    }



}
