package com.qiho.center.biz.service.impl.agent;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.agent.AgentMerchantsDto;
import com.qiho.center.api.params.agent.AgentMerchantPageParams;
import com.qiho.center.biz.service.agent.BaiqiAgentMerchantService;
import com.qiho.center.common.dao.QihoMerchantDAO;
import com.qiho.center.common.daoh.qiho.agent.BaiqiAgentMerchantMapper;
import com.qiho.center.common.entity.merchant.QihoMerchantEntity;
import com.qiho.center.common.entityd.qiho.agent.BaiqiAgentMerchantRelationEntity;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;

/**
 * 代理商和商家关联关系服务
 * Author: zhanghuifeng
 * Date:   11:14 2017/12/15
 */
@Service
public class BaiqiAgentMerchantServiceImpl implements BaiqiAgentMerchantService {

	@Resource
	private BaiqiAgentMerchantMapper baiqiAgentMerchantMapper;
	@Resource
	private QihoMerchantDAO qihoMerchantDAO;

	@Override
	public List<Long> findExistMerchantIds(Long agentId) {
		return baiqiAgentMerchantMapper.findMerchantIdsByAgentId(agentId);
	}

	@Override
	public Boolean batchInsert(List<BaiqiAgentMerchantRelationEntity> list) {
		return baiqiAgentMerchantMapper.batchInsert(list) > 0;
	}

	@Override
	public List<Long> findAllMerchantIds() {
		return baiqiAgentMerchantMapper.findAllMerchantIds();
	}

	@Override
	public Boolean findByAgentIdAndMerchantId(Long agentId, Long merchantId) {
		return baiqiAgentMerchantMapper.findByAgentIdAndMerchantId(agentId,merchantId) == 1;
	}

	@Override
	public PagenationDto<AgentMerchantsDto> findPageByAgentId(AgentMerchantPageParams pageParams) {
		List<Long> merchantIds = baiqiAgentMerchantMapper.findMerchantIdsPageByAgentId(pageParams);
		PagenationDto<AgentMerchantsDto> pagenationDto = new PagenationDto<>();
		if(CollectionUtils.isEmpty(merchantIds)){
			pagenationDto.setList(Collections.emptyList());
			pagenationDto.setTotal(0);
			return pagenationDto;
		}
		List<QihoMerchantEntity> merchantEntities = qihoMerchantDAO.listByIds(merchantIds);
		Map<Long,QihoMerchantEntity> merchantMap = new HashMap<>();
		for(QihoMerchantEntity entity : merchantEntities){
			merchantMap.put(entity.getId(),entity);
		}
		merchantIds.sort((o1, o2) -> o1 < o2 ? 1 : -1);
		List<AgentMerchantsDto> list = new ArrayList<>(merchantIds.size());
		for(Long merchantId : merchantIds){
			QihoMerchantEntity merchantEntity = merchantMap.get(merchantId);
			list.add(BeanUtils.copy(merchantEntity,AgentMerchantsDto.class));
		}
		Integer total = baiqiAgentMerchantMapper.countPageByCondition(pageParams);
		pagenationDto.setList(list);
		pagenationDto.setTotal(total);
		return pagenationDto;
	}

}
