package com.qiho.center.biz.service.impl.agent;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.SimpleIdAndNameDto;
import com.qiho.center.api.dto.agent.BaiqiAgentDto;
import com.qiho.center.api.enums.finance.BaiqiCommercialTenantTypeEnum;
import com.qiho.center.api.params.agent.AgentPageParam;
import com.qiho.center.biz.service.agent.BaiqiAgentService;
import com.qiho.center.common.constant.DsConstants;
import com.qiho.center.common.daoh.qiho.agent.BaiqiAgentMapper;
import com.qiho.center.common.daoh.qiho.finance.BaiqiFinanceMapper;
import com.qiho.center.common.entityd.qiho.agent.BaiqiAgentEntity;
import com.qiho.center.common.entityd.qiho.finance.BaiqiFinanceEntity;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.*;

/**
 * 代理商服务
 * Author: zhanghuifeng
 * Date:   19:16 2017/12/14
 */
@Service("baiqiAgentService")
public class BaiqiAgentServiceImpl implements BaiqiAgentService {

    @Resource
    private BaiqiAgentMapper baiqiAgentMapper;

    @Resource
    private BaiqiFinanceMapper baiqiFinanceMapper;

    @Override
    public Map<Long, BaiqiAgentEntity> findByIdsMap(List<Long> ids) {
        if(CollectionUtils.isEmpty(ids)){
            return Collections.emptyMap();
        }
        List<BaiqiAgentEntity> agentEntities = baiqiAgentMapper.findByIds(ids);
        if (CollectionUtils.isEmpty(agentEntities)) {
            return Collections.emptyMap();
        }
        Map<Long, BaiqiAgentEntity> map = new HashMap<>();
        for (BaiqiAgentEntity entity : agentEntities) {
            map.put(entity.getId(), entity);
        }
        return map;
    }


    @Override
    public List<BaiqiAgentEntity> findAll() {
        return baiqiAgentMapper.findAll();
    }

    @Override
    public PagenationDto<BaiqiAgentDto> find4Page(AgentPageParam params) {
        PagenationDto<BaiqiAgentDto> page = new PagenationDto<>();
        if (params.getOffset() == null || params.getMax() == null) {
            page.setTotal(0);
            return page;
        }
        Integer count = baiqiAgentMapper.countByQuery(params);
        page.setTotal(count);
        if (count == 0) {
            return page;
        }

        List<BaiqiAgentDto> list = BeanUtils.copyList(baiqiAgentMapper.listByQuery(params), BaiqiAgentDto.class);
        page.setList(list);
        return page;
    }

    @Override
    public Boolean update(BaiqiAgentDto agentDto) {
        return baiqiAgentMapper.update(BeanUtils.copy(agentDto,BaiqiAgentEntity.class)) > 0;
    }

    @Override
    @Transactional(DsConstants.DATABASE_QIHO)
    public Boolean insert(BaiqiAgentEntity agentEntity) {
        Integer res1 = baiqiAgentMapper.insert(agentEntity);
        // 同步创建代理商资金账户
        BaiqiFinanceEntity financeEntity = new BaiqiFinanceEntity();
        financeEntity.setRelationId(agentEntity.getId());
        financeEntity.setRelationType(BaiqiCommercialTenantTypeEnum.AGENT.getType());
        Integer res2 = baiqiFinanceMapper.insertAccountFinance(financeEntity);
        return res1 + res2 == 2;
    }

    @Override
    public BaiqiAgentEntity findById(Long id) {
        return baiqiAgentMapper.findById(id);
    }

    @Override
    public List<SimpleIdAndNameDto> findSimpleAll() {
        List<BaiqiAgentEntity> list = baiqiAgentMapper.findAll();
        if (CollectionUtils.isEmpty(list)){
            return Collections.emptyList();
        }
        List<SimpleIdAndNameDto>  dtos = new ArrayList<>();
        for (BaiqiAgentEntity entity : list){
            SimpleIdAndNameDto dto = new SimpleIdAndNameDto();
            dto.setId(entity.getId());
            dto.setName(entity.getAgentName());
            dtos.add(dto);
        }
        return dtos;
    }

    @Override
    public BaiqiAgentEntity findAgentByMerchantId(String merchantId) {
        return baiqiAgentMapper.findAgentByMerchantId(merchantId);
    }

    @Override
    public BaiqiAgentDto findByAgentName(String agentName) {
        return BeanUtils.copy(baiqiAgentMapper.findByAgentName(agentName), BaiqiAgentDto.class);
    }
}
