package com.qiho.center.biz.service.impl.check.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.qiho.center.api.dto.OrderSnapshotDto;
import com.qiho.center.biz.service.impl.check.IPMobileCheckService;
import com.qiho.center.biz.util.AMapUtil;
import com.qiho.center.biz.util.MobileHomeLocationUtil;
import com.qiho.center.common.daoh.qiho.CheckAddressMapper;
import com.qiho.center.common.entityd.qiho.CheckAddressEntity;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 当创建订单时
 * 根据订单信息
 * 获取检测信息(ip和手机号 归属地 省、市)
 * Created by weny.cai on 2018/5/14.
 */
@Service
public class IPMobileCheckServiceImpl implements IPMobileCheckService{

    @Autowired
    CheckAddressMapper checkAddressMapper;

    /**
     * 检测出信息
     * 保存入数据库
     * @param orderSnapshotDto
     */
    @Override
    public void checkToSave(OrderSnapshotDto orderSnapshotDto) {
        //手机号归属地查询
        String mobileHomeLocation = MobileHomeLocationUtil.getHomeLocation(orderSnapshotDto.getMobile());
        String mobileProvince = "";
        String mobileCity = "";
        if(StringUtils.isNotBlank(mobileHomeLocation)){
            JSONObject mobileJson = JSONObject.parseObject(mobileHomeLocation);
            mobileProvince = mobileJson.getString("province");
            JSONArray jsonArray = JSONArray.parseArray(mobileJson.getString("area"));
            mobileCity = jsonArray.getJSONObject(0).getString("city");
        }
        //IP归属地
        String ipHomeLocation = AMapUtil.getAMapAddress(orderSnapshotDto.getIp());
        JSONObject ipJson = JSONObject.parseObject(ipHomeLocation);
        String ipProvince = ipJson.getString("province");
        String ipCity = ipJson.getString("city");
        CheckAddressEntity entity = new CheckAddressEntity();
        entity.setOrderId(orderSnapshotDto.getOrderId());
        if("[]".equals(ipCity)){
            entity.setIpCity("");
        }else{
            entity.setIpCity(ipCity);
        }
        if("[]".equals(ipProvince)){
            entity.setIpProvince("");
        }else{
            entity.setIpProvince(ipProvince);
        }
        entity.setMobileCity(mobileCity);
        entity.setMobileProvince(mobileProvince);
        checkAddressMapper.insert(entity);
    }
}
