package com.qiho.center.biz.service.impl.coupon;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.qiho.center.api.dto.coupon.ActiveDto;
import com.qiho.center.api.params.ActiveQueryParams;
import com.qiho.center.biz.bo.CouponBo;
import com.qiho.center.biz.service.coupon.ActiveService;
import com.qiho.center.common.constant.DsConstants;
import com.qiho.center.common.dao.coupon.QihoActiveDAO;
import com.qiho.center.common.dao.coupon.QihoCouponActiveDAO;
import com.qiho.center.common.entity.coupon.QihoActiveEntity;
import com.qiho.center.common.entity.coupon.QihoCouponActiveEntity;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * Created by danke on 2017/10/31.
 */
@Service
public class ActiveServiceImpl implements ActiveService {

    @Resource
    private QihoActiveDAO qihoActiveDAO;

    @Resource
    private QihoCouponActiveDAO couponActiveDAO;

    @Resource
    private CouponBo couponBo;

    @Override
    @Transactional(DsConstants.DATABASE_QIHO)
    public Long insert(ActiveDto dto) {
        QihoActiveEntity activeEntity = BeanUtils.copy(dto,QihoActiveEntity.class);
        qihoActiveDAO.insert(activeEntity);
        Long activeId =activeEntity.getId();
        List<Long> couponIds = dto.getCouponIds();
        if (CollectionUtils.isNotEmpty(couponIds)){
            List<QihoCouponActiveEntity> couponActiveEntities = idsParseToEntities(activeId,couponIds);
            couponBo.batchInsertCouponActive(couponActiveEntities,Boolean.TRUE);//新增
        }
        return activeId;
    }

    @Override
    @Transactional(DsConstants.DATABASE_QIHO)
    public Boolean update(ActiveDto dto) {
        qihoActiveDAO.update(BeanUtils.copy(dto,QihoActiveEntity.class));
        Long activeId = dto.getId();
        List<Long> changeCouponIds = dto.getCouponIds();
        //因为是编辑,先查询原本已经有的
        List<QihoCouponActiveEntity> oldCouponActives = couponActiveDAO.findByActiveId(activeId);
        if (CollectionUtils.isEmpty(oldCouponActives)){
            //从没绑定过,则全部是新增
            List<QihoCouponActiveEntity> couponActiveEntities = idsParseToEntities(activeId,changeCouponIds);
            couponBo.batchInsertCouponActive(couponActiveEntities,Boolean.TRUE);
        }else{
            List<Long> oldCouponIds = oldCouponActives.stream().map(QihoCouponActiveEntity::getCouponId).collect(Collectors.toList());
            List<Long> midCoupoIds = new ArrayList<>();
            midCoupoIds.addAll(changeCouponIds);
            midCoupoIds.retainAll(oldCouponIds);
            changeCouponIds.removeAll(midCoupoIds);
            oldCouponIds.removeAll(midCoupoIds);
            //剩下的changeCouponIds是需要新增的,
            List<QihoCouponActiveEntity> insertEntities = idsParseToEntities(activeId,changeCouponIds);
            couponBo.batchInsertCouponActive(insertEntities,Boolean.TRUE);
            //剩下的oldCouponIds是需要删除的
            List<QihoCouponActiveEntity> deleteEntities = idsParseToEntities(activeId,oldCouponIds);
            couponBo.batchInsertCouponActive(deleteEntities,Boolean.FALSE);
        }
        return Boolean.TRUE;
    }

    @Override
    @Transactional(DsConstants.DATABASE_QIHO)
    public Integer delete(Long activeId) {
        //删除活动,并且级联删除活动下绑定的模板关联关系
        couponActiveDAO.deleteByActiveId(activeId);
        return qihoActiveDAO.delete(activeId);
    }

    @Override
    public ActiveDto findByActiveId(Long activeId) {
        ActiveDto activeDto = BeanUtils.copy(qihoActiveDAO.findByActiveId(activeId),ActiveDto.class);
        //查询绑定的模板
        List<QihoCouponActiveEntity> couponActiveEntities = couponActiveDAO.findByActiveId(activeId);
        if (CollectionUtils.isNotEmpty(couponActiveEntities)){
            List<Long> couponIds = couponActiveEntities.stream().map(QihoCouponActiveEntity::getCouponId).collect(Collectors.toList());
            activeDto.setCouponIds(couponIds);
        }
        return activeDto;
    }

    @Override
    public List<ActiveDto> findActiveByQuery(ActiveQueryParams params) {
        List<QihoActiveEntity> qihoActiveEntities = qihoActiveDAO.findActiveByQuery(params);
        return BeanUtils.copyList(qihoActiveEntities,ActiveDto.class);
    }

    @Override
    public Integer countActiveByQuery(ActiveQueryParams params) {
        return qihoActiveDAO.countActiveByQuery(params);
    }

    @Override
    public ActiveDto findAbleNewsActive() {
        return BeanUtils.copy(qihoActiveDAO.findAbleNewsActive(),ActiveDto.class);
    }

    private List<QihoCouponActiveEntity> idsParseToEntities(Long activeId,List<Long> couponIds){
        if (CollectionUtils.isEmpty(couponIds))
            return new ArrayList<>();
        return couponIds.stream().map(e-> {
            QihoCouponActiveEntity couponActiveEntity = new QihoCouponActiveEntity();
            couponActiveEntity.setCouponId(e);
            couponActiveEntity.setActiveId(activeId);
            couponActiveEntity.setDeleted(Boolean.FALSE);
            return couponActiveEntity;
        }).collect(Collectors.toList());
    }
}
