package com.qiho.center.biz.service.impl.coupon;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.qiho.center.api.dto.coupon.CouponActiveDto;
import com.qiho.center.biz.service.coupon.CouponActiveService;
import com.qiho.center.common.dao.coupon.QihoCouponActiveDAO;
import com.qiho.center.common.entity.coupon.QihoCouponActiveEntity;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * Created by danke on 2017/10/31.
 */
@Service
public class CouponActiveServiceImpl implements CouponActiveService {

    @Resource
    private QihoCouponActiveDAO qihoCouponActiveDAO;


    @Override
    public Integer insert(CouponActiveDto dto) {
        return qihoCouponActiveDAO.insert(BeanUtils.copy(dto,QihoCouponActiveEntity.class));
    }

    @Override
    public Integer delete(CouponActiveDto dto) {
        QihoCouponActiveEntity couponActiveEntity = BeanUtils.copy(dto,QihoCouponActiveEntity.class);
        return qihoCouponActiveDAO.delete(couponActiveEntity);
    }

    @Override
    public List<CouponActiveDto> findByActiveId(Long activeId) {
        List<QihoCouponActiveEntity> couponActiveEntities = qihoCouponActiveDAO.findByActiveId(activeId);
        return BeanUtils.copyList(couponActiveEntities,CouponActiveDto.class);
    }

}
