package com.qiho.center.biz.service.impl.coupon;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.coupon.CouponAstrictDto;
import com.qiho.center.api.dto.coupon.CouponDto;
import com.qiho.center.api.dto.coupon.CouponOrderDto;
import com.qiho.center.api.params.CouponQueryParams;
import com.qiho.center.biz.service.coupon.CouponSerivce;
import com.qiho.center.common.constant.DsConstants;
import com.qiho.center.common.dao.coupon.QihoCouponActiveDAO;
import com.qiho.center.common.dao.coupon.QihoCouponAstrictDAO;
import com.qiho.center.common.dao.coupon.QihoCouponDAO;
import com.qiho.center.common.entity.coupon.QihoCouponAstrictEntity;
import com.qiho.center.common.entity.coupon.QihoCouponEntity;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by danke on 2017/10/31.
 */
@Service
public class CouponServiceImpl implements CouponSerivce {

    @Resource
    private QihoCouponDAO qihoCouponDAO;

    @Resource
    private QihoCouponAstrictDAO qihoCouponAstrictDAO;

    @Resource
    private QihoCouponActiveDAO qihoCouponActiveDAO;

    @Override
    @Transactional(DsConstants.DATABASE_QIHO)
    public Boolean insert(CouponDto dto) {
        QihoCouponEntity entity = BeanUtils.copy(dto, QihoCouponEntity.class);
        qihoCouponDAO.insert(entity);
        // 插入优惠券模板限制
        List<CouponAstrictDto> couponAstrictList = dto.getCouponAstrictList();
        if (CollectionUtils.isNotEmpty(couponAstrictList)){
            for (CouponAstrictDto couponAstrictDto : couponAstrictList){
                QihoCouponAstrictEntity couponAstrictEntity = BeanUtils.copy(couponAstrictDto,QihoCouponAstrictEntity.class);
                couponAstrictEntity.setCouponId(entity.getId());
                qihoCouponAstrictDAO.insert(couponAstrictEntity);
            }
        }
        return Boolean.TRUE;
    }

    @Override
    public Integer update(CouponOrderDto dto) {
        return qihoCouponDAO.update(BeanUtils.copy(dto,QihoCouponEntity.class));
    }

    @Override
    @Transactional(DsConstants.DATABASE_QIHO)
    public Integer delete(Long couponId) {
        qihoCouponAstrictDAO.deleteByCouponId(couponId);
        qihoCouponActiveDAO.deleteByCouponId(couponId);
        //删除活动模板关联表对应的模板
        return qihoCouponDAO.delete(couponId);
    }

    @Override
    public CouponOrderDto findByCouponId(Long couponId) {
        return null;
    }

    @Override
    public PagenationDto<CouponDto> findCouponByQuery(CouponQueryParams params) {
        PagenationDto<CouponDto> pagenation= new PagenationDto<>();
        // 查询总数量
        Integer total = qihoCouponDAO.countCouponByQuery(params);
        pagenation.setTotal(total);
        if (total == 0){
            return pagenation;
        }
        // 查询优惠券模板
        List<QihoCouponEntity> entities = qihoCouponDAO.findCouponByQuery(params);
        List<CouponDto> couponList = BeanUtils.copyList(entities,CouponDto.class);
        List<Long> couponIds = Lists.newArrayList();
        entities.stream().forEach(e -> couponIds.add(e.getId()));
        // 查询优惠券限制
        List<QihoCouponAstrictEntity> couponAstrictEntityList = qihoCouponAstrictDAO.batchFindByCouponIds(couponIds);
        List<CouponAstrictDto> couponAstrictList = BeanUtils.copyList(couponAstrictEntityList,CouponAstrictDto.class);
        // 一个优惠券模板可能有多个优惠券限制
        for (CouponDto coupon : couponList){
            List<CouponAstrictDto> couponAstrictDtos = new ArrayList<>();
            for (CouponAstrictDto couponAstrictDto : couponAstrictList){
                if (String.valueOf(coupon.getId()).equals(String.valueOf(couponAstrictDto.getCouponId()))) {
                    couponAstrictDtos.add(couponAstrictDto);
                }
            }
            coupon.setCouponAstrictList(couponAstrictDtos);
        }

        pagenation.setList(couponList);
        return pagenation;
    }

    @Override
    public List<CouponDto> batchFindCouponByIds(List<Long> couponIds) {
        List<QihoCouponEntity> couponEntities = qihoCouponDAO.batchFindCouponByIds(couponIds);
        return BeanUtils.copyList(couponEntities,CouponDto.class);
    }
}
