package com.qiho.center.biz.service.impl.logistics;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.qiho.center.biz.service.logistics.Express100LogisticsService;
import com.qiho.center.common.daoh.qiho.logistics.BaiqiLogisticsMapper;
import com.qiho.center.common.daoh.qiho.logistics.Express100LogisticsMapper;
import com.qiho.center.common.entityd.qiho.logistics.BaiqiLogisticsEntity;
import com.qiho.center.common.entityd.qiho.logistics.Express100LogisticsEntity;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.text.MessageFormat;
import java.util.concurrent.TimeUnit;

/**
 * 快递100物流公司服务
 * Author: zhanghuifeng
 * Date:   16:27 2018/1/2
 */
@Service("express100LogisticsService")
public class Express100LogisticsServiceImpl implements Express100LogisticsService {

    @Resource
    private Express100LogisticsMapper express100LogisticsMapper;
    @Resource
    private BaiqiLogisticsMapper baiqiLogisticsMapper;

    //存放所有百奇物流公司code对应的快递100物流缓存
    private static final String BAQILOGISTICSCODE_EXPRESS100LOGISTICS_KEY = "baqiLogisticsCode_Express100Logistics_{0}";
    private static final Cache<String,Express100LogisticsEntity> baiqi_express100_LogisticsLocalCache = CacheBuilder.newBuilder().maximumSize(100).expireAfterWrite(15, TimeUnit.MINUTES).build();

    @Override
    public Express100LogisticsEntity findByCode(String logisticsCode) {
        return express100LogisticsMapper.findByCode(logisticsCode);
    }

    @Override
    public Express100LogisticsEntity findByBaiqiLogisticsCode(String baiqiLogisticsCode) {
        String key = MessageFormat.format(BAQILOGISTICSCODE_EXPRESS100LOGISTICS_KEY,baiqiLogisticsCode);
        Express100LogisticsEntity entity = baiqi_express100_LogisticsLocalCache.getIfPresent(key);
        if (entity == null){
            BaiqiLogisticsEntity baiqiLogisticsEntity  = baiqiLogisticsMapper.findByCode(baiqiLogisticsCode);
            if (baiqiLogisticsEntity != null){
                entity = express100LogisticsMapper.findByBaiqiLogisticsId(baiqiLogisticsEntity.getId());
                baiqi_express100_LogisticsLocalCache.put(key,entity);
            }
        }
        return entity;
    }
}
