package com.qiho.center.biz.service.impl.merchant;

import java.util.List;
import java.util.Set;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.qiho.center.api.dto.merchant.ItemMerchantDto;
import com.qiho.center.biz.service.merchant.ItemMerchantService;
import com.qiho.center.common.dao.QihoItemMerchantDAO;
import com.qiho.center.common.entity.merchant.QihoItemMerchantEntity;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.wolf.utils.BeanUtils;

/**
 * @author chensong
 * @create 2017-11-16 15:02
 **/
@Service
public class ItemMerchantServiceImpl implements ItemMerchantService {

    @Autowired
    private QihoItemMerchantDAO qihoItemMerchantDAO;

    @Override
    public Integer deleteByItemId(Long itemId, Long gmtModifier) {
        return qihoItemMerchantDAO.deleteByItemId(itemId, gmtModifier);
    }

    @Override
    public Integer insert(ItemMerchantDto dto) throws BizException {
        if (dto.getItemId() == null || dto.getMerchantId() == null) {
            throw new BizException("未传入商品Id或商家Id");
        }
        if (qihoItemMerchantDAO.findByItemId(dto.getItemId()) != null) {
            throw new BizException("商品已经存在所属商家");
        }
        return qihoItemMerchantDAO.insert(BeanUtils.copy(dto, QihoItemMerchantEntity.class));
    }

    @Override
    public Integer deleteBatchByItemId(List<Long> itemIdList, Long gmtModifier) throws BizException {
        if (CollectionUtils.isEmpty(itemIdList)) {
            throw new BizException("传入id列表为空！");
        }
        return qihoItemMerchantDAO.deleteBatchByItemId(itemIdList, gmtModifier);
    }

    @Override
    public Integer deleteBatch(Set<Long> idSet, Long gmtModifier) throws BizException {
        if (CollectionUtils.isEmpty(idSet)) {
            throw new BizException("传入id列表为空");
        }
        return qihoItemMerchantDAO.deleteBatch(idSet, gmtModifier);
    }
}
