package com.qiho.center.biz.service.impl.monitor;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.monitor.LogisticsMonitorPlanDto;
import com.qiho.center.api.dto.monitor.LogisticsMonitorStrategyDto;
import com.qiho.center.api.params.MonitorPlanQueryParam;
import com.qiho.center.biz.service.monitor.LogisticsMonitorPlanService;
import com.qiho.center.common.constant.DsConstants;
import com.qiho.center.common.daoh.qiho.QihoLogisticsMonitorPlanMapper;
import com.qiho.center.common.daoh.qiho.QihoLogisticsMonitorStrategyMapper;
import com.qiho.center.common.entityd.qiho.monitor.LogisticsMonitorPlanEntity;
import com.qiho.center.common.entityd.qiho.monitor.LogisticsMonitorStrategyEntity;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.time.DateUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * Created by qianjue on 2017/10/31.
 */
@Service
public class LogisticsMonitorPlanServiceImpl implements LogisticsMonitorPlanService {

	@Resource
	private QihoLogisticsMonitorPlanMapper  qihoLogisticsMonitorPlanMapper;

	@Resource
	private QihoLogisticsMonitorStrategyMapper  qihoLogisticsMonitorStrategyMapper;

	@Override
	@Transactional(DsConstants.DATABASE_QIHO)
	public int saveLogistMonitorPlan(LogisticsMonitorPlanDto dto) {
		if(null ==dto.getId()){
			return createMonitorPlan(dto);
		}else{
			return updateMonitorPlan(dto);
		}
	}

	private int updateMonitorPlan(LogisticsMonitorPlanDto dto) {
		LogisticsMonitorPlanEntity planEntity = BeanUtils.copy(dto,LogisticsMonitorPlanEntity.class);
		qihoLogisticsMonitorPlanMapper.update(planEntity);
		List<LogisticsMonitorStrategyEntity> strategyList = BeanUtils.copyList(dto.getStrategyDtoList(),
				LogisticsMonitorStrategyEntity.class);
		//查询出来历史的记录
		List<LogisticsMonitorStrategyEntity> strategyOldList =
				qihoLogisticsMonitorStrategyMapper.selectListByPlanId(planEntity.getId());
		//比较哪些是新增的,哪些是修改的
		Map<Long,LogisticsMonitorStrategyEntity> strategyOldMap = Maps.newHashMap();
		List<Long> oldIdList = Lists.newArrayList();
		strategyOldList.stream().forEach(strategy ->{
			strategyOldMap.put(strategy.getId(),strategy);
			oldIdList.add(strategy.getId());
		});

		List<LogisticsMonitorStrategyEntity> newList = Lists.newArrayList();
		List<LogisticsMonitorStrategyEntity> updateList = Lists.newArrayList();
		strategyList.forEach(strategy->{
			if(null==strategy.getId()){
				strategy.setPlanId(planEntity.getId());
				strategy.setNextExecuteTime(planEntity.getStartTime().before(new Date()) ? new Date() : planEntity.getStartTime());
				newList.add(strategy);
			}else{
				LogisticsMonitorStrategyEntity oldStrategy = strategyOldMap.get(strategy.getId());
				//修改下次执行时间
				if(null==oldStrategy.getLastExecuteTime()){
					strategy.setNextExecuteTime(planEntity.getStartTime().before(new Date()) ? new Date() : planEntity.getStartTime());
				}else{
					strategy.setNextExecuteTime(DateUtils.addMinutes(oldStrategy.getLastExecuteTime(),strategy.getIntervalNum()));
				}
				updateList.add(strategy);
				oldIdList.remove(strategy.getId());
			}
		});
		deleteData(planEntity.getId(),oldIdList);
		//新增
		addNewData(newList);
		//修改
		updateData(updateList);
		return 1;
	}

	//删除
	private void deleteData(Long id, List<Long> oldIdList) {
		if(CollectionUtils.isNotEmpty(oldIdList)){
			Map<String,Object> param = Maps.newHashMap();
			param.put("planId",id);
			param.put("strategyIdList",oldIdList);
			qihoLogisticsMonitorStrategyMapper.deleteByParam(param);
		}
	}

	private void updateData(List<LogisticsMonitorStrategyEntity> updateList) {
		if(CollectionUtils.isNotEmpty(updateList)){
			qihoLogisticsMonitorStrategyMapper.batchUpdate(updateList);
		}
	}

	private void addNewData(List<LogisticsMonitorStrategyEntity> newList) {
		if(CollectionUtils.isNotEmpty(newList)){
			qihoLogisticsMonitorStrategyMapper.batchInsert(newList);
		}
	}

	/**
	 * 新增
	 * @param dto
	 * @return
	 */
	private int createMonitorPlan(LogisticsMonitorPlanDto dto) {
		LogisticsMonitorPlanEntity planEntity = BeanUtils.copy(dto,LogisticsMonitorPlanEntity.class);
		planEntity.setIsDelete(0);
		qihoLogisticsMonitorPlanMapper.insert(planEntity);
		//新增记录
		List<LogisticsMonitorStrategyEntity> strategyList = BeanUtils.copyList(dto.getStrategyDtoList(),
				LogisticsMonitorStrategyEntity.class);
		strategyList.stream().forEach(strategy -> {
			strategy.setPlanId(planEntity.getId());
			strategy.setNextExecuteTime(planEntity.getStartTime().before(new Date()) ? new Date() : planEntity.getStartTime());
		});
		qihoLogisticsMonitorStrategyMapper.batchInsert(strategyList);
		return 1;
	}

	@Override
	public LogisticsMonitorPlanDto getLogisticsMonitorPlanById(Long id) {
		LogisticsMonitorPlanEntity  planEntity = qihoLogisticsMonitorPlanMapper.selectById(id);
		LogisticsMonitorPlanDto resultDto = BeanUtils.copy(planEntity,LogisticsMonitorPlanDto.class);
		//查询详情
		List<LogisticsMonitorStrategyEntity> strategyList =
				qihoLogisticsMonitorStrategyMapper.selectListByPlanId(planEntity.getId());
		resultDto.setStrategyDtoList(BeanUtils.copyList(strategyList, LogisticsMonitorStrategyDto.class));
		return resultDto;
	}

	@Override
	public int deleteMonitorPlan(Long id) {
		return qihoLogisticsMonitorPlanMapper.deleteById(id);
	}

	@Override
	public PagenationDto<LogisticsMonitorPlanDto> queryPageList(MonitorPlanQueryParam queryParam) {
		PagenationDto<LogisticsMonitorPlanDto> page = new PagenationDto<>();
		int count = qihoLogisticsMonitorPlanMapper.selectPageCount(queryParam);
		page.setTotal(count);
		if(count==0){
			page.setList(Lists.newArrayList());
			return page;
		}
		List<LogisticsMonitorPlanEntity> list = qihoLogisticsMonitorPlanMapper.selectPageByParam(queryParam);
		page.setList(BeanUtils.copyList(list,LogisticsMonitorPlanDto.class));
		return page;
	}

	@Override
	public LogisticsMonitorPlanEntity queryValidMonitorPlan(String logisticsCode) {
		return  qihoLogisticsMonitorPlanMapper.selectValidMonitorPlan(logisticsCode);
	}


	@Override
	public List<LogisticsMonitorStrategyEntity> selectStrategyListByPlanId(Long planId) {
		return  qihoLogisticsMonitorStrategyMapper.selectListByPlanId(planId);
	}

	@Override
	public int updateStrategyExecuteTime(LogisticsMonitorStrategyEntity strategyEntity) {
		return qihoLogisticsMonitorStrategyMapper.updateExecuteTime(strategyEntity);
	}

}
