package com.qiho.center.biz.service.impl.monitor;

import cn.com.duiba.wolf.utils.BeanUtils;
import cn.com.duiba.wolf.utils.DateUtils;
import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qiho.center.api.dto.monitor.LogisticsMonitorReportDto;
import com.qiho.center.api.params.MonitorReportQueryParam;
import com.qiho.center.biz.service.monitor.MonitorReportService;
import com.qiho.center.common.daoh.qihostatistics.QihoLogisticsMonitorReportMapper;
import com.qiho.center.common.entityd.qiho.monitor.LogisticsMonitorReportEntity;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * Created by qianjue on 2017/11/2.
 */
@Service
public class MonitorReportServiceImpl implements MonitorReportService {

	@Resource
	private QihoLogisticsMonitorReportMapper qihoLogisticsMonitorReportMapper;

	@Override
	public List<LogisticsMonitorReportDto> queryList(MonitorReportQueryParam queryParam) {
		Map<String,Object> map = Maps.newHashMap();
		map.put("monitorStatus",queryParam.getMonitorStatus());
		map.put("startTime",queryParam.getStartTime());
		map.put("endTime",queryParam.getEndtime());
		List<LogisticsMonitorReportEntity> list = qihoLogisticsMonitorReportMapper.selectAggregateReport(map);
		if(CollectionUtils.isEmpty(list)){
			return Lists.newArrayList();
		}
		return BeanUtils.copyList(list,LogisticsMonitorReportDto.class);
	}

	@Override
	public int insert(LogisticsMonitorReportEntity entity) {
		return qihoLogisticsMonitorReportMapper.insert(entity);
	}


	@Override
	public LogisticsMonitorReportEntity selectMonitorReportForSMS() {
		Map<String,Object> param = Maps.newHashMap();
		Date  now = new Date();
		param.put("startTime", DateUtils.getStartTime(DateUtils.daysAddOrSub(now,-1)));
		param.put("endTime",DateUtils.getEndTime(DateUtils.daysAddOrSub(now,-1)));
		return qihoLogisticsMonitorReportMapper.selectReportByParam(param);
	}
}
