package com.qiho.center.biz.service.impl.order;

import com.qiho.center.api.dto.SimpleIdAndNameDto;
import com.qiho.center.biz.service.order.StrategyMerchantService;
import com.qiho.center.common.daoh.qiho.order.StrategyMerchantMapper;
import com.qiho.center.common.entityd.qiho.order.StrategyMerchantEntity;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Collections;
import java.util.List;

/**
 * 策略与商家service
 *
 * @author peanut.huang
 * @date 2018/3/15.
 */
@Service("strategyMerchantService")
public class StrategyMerchantServiceImpl implements StrategyMerchantService {


    @Resource
    private StrategyMerchantMapper strategyMerchantMapper;

    @Override
    public StrategyMerchantEntity find(Long merchantId, Long strategyId) {

        if(merchantId == null || strategyId == null){
            return null;
        }

        return strategyMerchantMapper.find(merchantId, strategyId);
    }

    @Override
    public Boolean delMerchantStrategy(Long merchantId, Long strategyId) {
        return strategyMerchantMapper.delMerchantStrategy(merchantId, strategyId) > 0;
    }

    @Override
    public Boolean batchInsert(List<StrategyMerchantEntity> insertList) {
        if(CollectionUtils.isEmpty(insertList)){
            return false;
        }

        return strategyMerchantMapper.batchInsert(insertList) > 0;
    }

    @Override
    public List<SimpleIdAndNameDto> findMerchants(Long strategyId) {
        if(strategyId == null){
            return Collections.emptyList();
        }
        return strategyMerchantMapper.findMerchants(strategyId);
    }
}
