package com.qiho.center.biz.service.impl.ordersms;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.qiho.center.api.constant.YZHSmsConstant;
import com.qiho.center.api.dto.ordertmp.OrderTmpDetailDto;
import com.qiho.center.api.enums.SmsTypeEnum;
import com.qiho.center.api.enums.ordersms.OrderSmsReceiveStatus;
import com.qiho.center.api.enums.ordersms.OrderSmsSendStatusEnum;
import com.qiho.center.biz.service.MediaWhiteListService;
import com.qiho.center.biz.service.order.SmsService;
import com.qiho.center.biz.service.ordersms.OrderSmsService;
import com.qiho.center.common.dao.QihoTemplateDAO;
import com.qiho.center.common.daoh.qiho.ChuangLanSmsCommitMapper;
import com.qiho.center.common.daoh.qiho.ordertmp.BaiqiOrderSmsMapper;
import com.qiho.center.common.entity.QihoTemplateEntity;
import com.qiho.center.common.entityd.qiho.ChuangLanSmsCommitEntity;
import com.qiho.center.common.entityd.qiho.ordertmp.BaiqiOrderSmsEntity;
import com.qiho.center.common.enums.SmsTemplateEnum;
import com.qiho.center.common.support.ShortUrlProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * @author chensong
 * @create 2018-05-21 19:27
 **/
@Service
public class OrderSmsServiceImpl implements OrderSmsService{

    private final static Logger LOGGER = LoggerFactory.getLogger(OrderSmsServiceImpl.class);

    @Autowired
    private MediaWhiteListService mediaWhiteListService;

    @Autowired
    private QihoTemplateDAO qihoTemplateDAO;

    @Autowired
    private SmsService smsService;

    @Autowired
    private ShortUrlProvider shortUrlProvider;

    @Autowired
    private BaiqiOrderSmsMapper baiqiOrderSmsMapper;


    @Autowired
    ChuangLanSmsCommitMapper chuangLanSmsCommitMapper;


    @Override
    public SmsTypeEnum sendMessage(OrderTmpDetailDto orderTmpDetailDto){
        // 订单编号
        String orderId = orderTmpDetailDto.getOrderId();
        // 商品简称
        String itemShortName = orderTmpDetailDto.getItemShortName();
        // 下单短信里的短连接
        String shortUrl = shortUrlProvider.saveShortUrl(orderId);
        // 手机号
        String mobile = orderTmpDetailDto.getMobile();
        Long appId = orderTmpDetailDto.getAppId();

        QihoTemplateEntity template = null;
        // 判断是否媒体白名单获取短信模板
        if (mediaWhiteListService.appInWhiteList(appId)) {
            // 白名单媒体
            template = qihoTemplateDAO.findByCode(SmsTemplateEnum.ORDER_SUCC_400.getCode());
        } else {
            // 非白名单媒体
            template = qihoTemplateDAO.findByCode(SmsTemplateEnum.ORDER_SUCCESS.getCode());
        }

        SmsTypeEnum smsTypeEnum = null;
        // 发送短信
        if (null != template && template.getTemplateEnable()) {
            Map<String, String> context = Maps.newHashMap();
            context.put("orderDetailUrl", shortUrl);
            context.put("itemName", itemShortName);
            smsTypeEnum = SmsTypeEnum.fromCode(template.getSmsType());

            String smsRetCode = YZHSmsConstant.YZHCODE.UNKNOWN;
            try {
                template.setReport(true);
                smsRetCode = smsService.singleSendRetCode(template, context, mobile);

                // 记录下单短信 tb_baiqi_order_sms
                saveOrderSms(orderId, mobile, smsTypeEnum, smsRetCode, OrderSmsSendStatusEnum.SUCCESS);
            } catch (Exception e) {
                LOGGER.warn("发送短信错误,orderId:{},smsTemplate:{}", orderId, template, e);
                saveOrderSms(orderId, mobile, smsTypeEnum, smsRetCode, OrderSmsSendStatusEnum.FAIL);
            }

        } else {
            LOGGER.warn("下单短信模板错误，orderId：{}，smsTemplate:{}",orderId, template);
        }

        // 发送下单温馨提示
        QihoTemplateEntity remindTemplate = qihoTemplateDAO.findByCode(SmsTemplateEnum.ORDER_NOTIFY.getCode());
        if (remindTemplate.getTemplateEnable()) {
            smsService.singleSend(remindTemplate, mobile);
        }

        return smsTypeEnum;
    }

    /**
     * 记录下单短信
     * @param orderId 订单编号
     * @param mobile 手机号
     * @param smsTypeEnum 短信服务商类型
     * @param smsRetCode 服务商的返回结果
     */
    private void saveOrderSms(String orderId, String mobile, SmsTypeEnum smsTypeEnum, String smsRetCode, OrderSmsSendStatusEnum snedStatus){
        BaiqiOrderSmsEntity entity = new BaiqiOrderSmsEntity();
        entity.setMobile(mobile);
        entity.setSmsType(smsTypeEnum.getNum());
        entity.setOrderId(orderId);
        entity.setSendStatus(snedStatus.getNum());

        //  是否需要接收短信报告
        if (smsTypeEnum.isNeedReport()) {
            entity.setReceiveStatus(OrderSmsReceiveStatus.UNPROCESSES.getNum());
        } else {
            entity.setReceiveStatus(OrderSmsReceiveStatus.PROCESSES.getNum());
        }

        if (smsTypeEnum == SmsTypeEnum.CHUANG_LAN){
            // 创蓝短信需要保存msgId
            JSONObject jsonObject = JSONObject.parseObject(smsRetCode);
            entity.setMsgId(jsonObject.getString("msgId"));

            // 创蓝的还要保存在另一张表
            ChuangLanSmsCommitEntity smsCommitEntity = new ChuangLanSmsCommitEntity();
            smsCommitEntity.setOrderId(orderId);
            smsCommitEntity.setMsgId(jsonObject.getString("msgId"));
            smsCommitEntity.setHandlerStatus(0);
            chuangLanSmsCommitMapper.insert(smsCommitEntity);

        } else {
            // 非创蓝的直接保存结果
            entity.setSyncResult(smsRetCode);
        }

        baiqiOrderSmsMapper.insertOrderSms(entity);
    }


}
