package com.qiho.center.biz.service.impl.ordertmp;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qiho.center.biz.service.ordertmp.FilterRuleHitService;
import com.qiho.center.common.daoh.qiho.ordertmp.BaiqiFilterRuleHitMapper;
import com.qiho.center.common.entityd.qiho.ordertmp.BaiqiFilterRuleHitEntity;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * @author chensong
 * @create 2018-05-22 11:46
 **/
@Service
public class FilterRuleHitServiceImpl implements FilterRuleHitService {

    @Autowired
    private BaiqiFilterRuleHitMapper baiqiFilterRuleHitMapper;


    @Override
    public void insert(String orderId, String rule) {
        BaiqiFilterRuleHitEntity entity = new BaiqiFilterRuleHitEntity();
        entity.setOrderId(orderId);
        entity.setRule(rule);
        baiqiFilterRuleHitMapper.insert(entity);
    }

    @Override
    public Map<String, List<String>> batchFindFilterRuleHit(List<String> list) {
        Map<String, List<String>> ruleMap = Maps.newHashMap();
        if (CollectionUtils.isEmpty(list)) {
            return ruleMap;
        }

        List<BaiqiFilterRuleHitEntity> ruleList = baiqiFilterRuleHitMapper.findByOrderIds(list);

        for (BaiqiFilterRuleHitEntity rule : ruleList) {
            String orderId = rule.getOrderId();
            if (ruleMap.get(orderId) != null) {
                List<String> rules = ruleMap.get(orderId);
                rules.add(rule.getRule());
                ruleMap.put(orderId, rules);
            } else {
                List<String> rules =Lists.newArrayList(rule.getRule());
                ruleMap.put(orderId, rules);
            }
        }

        return ruleMap;
    }
}
