package com.qiho.center.biz.service.impl.region;

import com.qiho.center.api.dto.region.BaiqiRegionRelationDto;
import com.qiho.center.biz.service.region.BaiqiRegionService;
import com.qiho.center.common.daoh.qiho.region.BaiqiRegionMapper;
import com.qiho.center.common.entityd.qiho.region.BaiqiRegionEntity;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * 中国省市区乡镇服务
 * Author: zhanghuifeng
 * Date:   2018/1/16 10:09
 */
@Service("baiqiRegionService")
public class BaiqiRegionServiceImpl implements BaiqiRegionService {
    @Resource
    private BaiqiRegionMapper baiqiRegionMapper;

    @Override
    public List<BaiqiRegionEntity> find(Long parentId) {
        return baiqiRegionMapper.find(parentId);
    }

    @Override
    public int updateAreaNum(int startId, int endId) {
        return baiqiRegionMapper.updateAreaNum(startId, endId);
    }

    @Override
    public int updateAreaNumByRegionName(String regionName, int areaNum) {
        return baiqiRegionMapper.updateAreaNumByRegionName(regionName, areaNum);
    }

    @Override
    public List<BaiqiRegionEntity> findNullAreaNumRegion(Integer regionLevel) {
        return baiqiRegionMapper.findNullAreaNumRegion(regionLevel);
    }

    @Override
    public BaiqiRegionRelationDto findRegionByAreaNum(Integer areaNum) {
        if (areaNum == null){
            return null;
        }
        BaiqiRegionRelationDto regionRelationDto = new BaiqiRegionRelationDto();
        BaiqiRegionEntity regionEntity = baiqiRegionMapper.findRegionByAreaNum(areaNum);
        if (regionEntity != null){
            forRegion(regionEntity,regionRelationDto,1);
        }
        return regionRelationDto;
    }

    /**
     * 根据区域级别获取省市区数据
     * @param regionEntity
     * @param regionRelationDto
     * @param count
     */
    private void forRegion(BaiqiRegionEntity regionEntity, BaiqiRegionRelationDto regionRelationDto,Integer count){
        get(regionRelationDto,regionEntity);
        BaiqiRegionEntity region = baiqiRegionMapper.findById(regionEntity.getParentId());
        //创建出口
        if (region != null && count < 5){
            count ++;
            forRegion(region, regionRelationDto,count);
        }
        if (regionRelationDto.getCityId() == null){
            List<BaiqiRegionEntity> list = baiqiRegionMapper.find(regionRelationDto.getProvinceId());
            if (CollectionUtils.isNotEmpty(list)){
                regionRelationDto.setCityId(list.get(0).getId());
                regionRelationDto.setCity(list.get(0).getRegionName());
            }
        }
        if (regionRelationDto.getDistrictId() == null){
            List<BaiqiRegionEntity> list = baiqiRegionMapper.find(regionRelationDto.getCityId());
            if (CollectionUtils.isNotEmpty(list)){
                regionRelationDto.setDistrictId(list.get(0).getId());
                regionRelationDto.setDistrict(list.get(0).getRegionName());
            }
        }

    }

    /**
     * 区分省市区
     * @param regionRelationDto
     * @param regionEntity
     * @return
     */
    private BaiqiRegionRelationDto get(BaiqiRegionRelationDto regionRelationDto, BaiqiRegionEntity regionEntity){
        switch (regionEntity.getRegionLevel()){
            case 1:
                regionRelationDto.setProvince(regionEntity.getRegionName());
                regionRelationDto.setProvinceId(regionEntity.getId());
                break;
            case 2:
                regionRelationDto.setCity(regionEntity.getRegionName());
                regionRelationDto.setCityId(regionEntity.getId());
                break;
            case 3:
                regionRelationDto.setDistrict(regionEntity.getRegionName());
                regionRelationDto.setDistrictId(regionEntity.getId());
                break;
            default:
                return regionRelationDto;
        }
        return regionRelationDto;
    }
}
