package com.qiho.center.biz.service.impl.tag;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.ResultDto;
import com.qiho.center.api.dto.tag.TagDto;
import com.qiho.center.api.params.tag.TagPageParam;
import com.qiho.center.biz.service.tag.TagService;
import com.qiho.center.common.constant.DsConstants;
import com.qiho.center.common.daoh.qiho.tag.QihoItemTagMapper;
import com.qiho.center.common.daoh.qiho.tag.QihoTagMapper;
import com.qiho.center.common.daoh.qiho.tag.QihoTagTypeMapper;
import com.qiho.center.common.entityd.qiho.tag.QihoTagEntity;
import com.qiho.center.common.entityd.qiho.tag.QihoTagTypeEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @author chensong
 * @create 2018-03-21 16:49
 **/
@Service
public class TagServiceImpl implements TagService {

    @Autowired
    private QihoTagMapper qihoTagMapper;

    @Autowired
    private QihoTagTypeMapper qihoTagTypeMapper;

    @Autowired
    private QihoItemTagMapper qihoItemTagMapper;

    @Override
    public ResultDto<Boolean> saveTag(TagDto tagDto) {
        QihoTagTypeEntity tagTypeEntity = qihoTagTypeMapper.findById(tagDto.getTypeId());
        if (Objects.equals(null, tagTypeEntity)) {
            return ResultDto.failResult("无效的标签类型");
        }

        if (Objects.equals(null, tagDto.getId())) {
            return createTag(tagDto);
        } else {
            return updateTag(tagDto);
        }
    }

    /**
     * 创建标签
     * @param tagDto
     * @return
     */
    @Transactional(DsConstants.DATABASE_QIHO)
    public ResultDto<Boolean> createTag(TagDto tagDto){
        QihoTagEntity param = BeanUtils.copy(tagDto, QihoTagEntity.class);
        QihoTagEntity tagEntity = qihoTagMapper.findByParam(param);
        if (!Objects.equals(null, tagEntity)) {
            return ResultDto.failResult("已有相同标签，请勿重复添加");
        }
        return ResultDto.successResult(qihoTagMapper.insert(param).intValue() == 1);
    }

    /**
     * 删除标签
     * @param tagDto
     * @return
     */
    @Transactional(DsConstants.DATABASE_QIHO)
    public ResultDto<Boolean> updateTag(TagDto tagDto){
        QihoTagEntity param = BeanUtils.copy(tagDto, QihoTagEntity.class);
        QihoTagEntity tagEntity = qihoTagMapper.findByParam(param);
        if (!Objects.equals(null, tagEntity)) {
            return ResultDto.failResult("已有相同标签或标签未修改，请勿重复保存");
        }
        QihoTagEntity oldTagEntity = qihoTagMapper.findById(tagDto.getId());
        if (oldTagEntity.getTypeId().longValue() != tagDto.getTypeId().longValue()) {
            // 如果迁移了标签类型 则删除标签关联的商品关系
            qihoItemTagMapper.deleteByTagId(tagDto.getId());
        }
        return ResultDto.successResult(qihoTagMapper.update(param).intValue() == 1);
    }

    @Override
    public Boolean delete(Long tagId) {
        qihoItemTagMapper.deleteByTagId(tagId);
        return qihoTagMapper.delete(tagId).intValue() == 1;
    }

    @Override
    public List<TagDto> findByTypeId(Long typeId) {
        List<QihoTagEntity> list = qihoTagMapper.findByTypeId(typeId);
        return BeanUtils.copyList(list, TagDto.class);
    }

    @Override
    public PagenationDto<TagDto> queryPage(TagPageParam param) {
        PagenationDto<TagDto> page = new PagenationDto<>();
        Integer count = qihoTagMapper.countPage(param);
        page.setTotal(count);
        if (count.intValue() == 0) {
            page.setList(Lists.newArrayList());
            return page;
        }
        List<QihoTagEntity> tagEntities = qihoTagMapper.queryPage(param);
        // 获取标签类型名称
        List<Long> typeIds = tagEntities.stream().map(QihoTagEntity::getTypeId).collect(Collectors.toList());
        List<QihoTagTypeEntity> tagType = qihoTagTypeMapper.findByTypeIds(typeIds);
        Map<Long, String> typaMap = Maps.newHashMap(); // key : 标签类型id  value ： 标签类型名称
        tagType.stream().forEach(e ->
            typaMap.put(e.getId(), e.getTypeName())
        );
        // 类型转换
        List<TagDto> tagDtoList = Lists.transform(tagEntities, e -> {
            TagDto tag = BeanUtils.copy(e, TagDto.class);
            tag.setTypeName(typaMap.get(e.getTypeId()));
            return tag;
        });
        page.setList(tagDtoList);
        return page;
    }


}
