package com.qiho.center.biz.service.impl.warning;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.warning.StockWarningDto;
import com.qiho.center.api.params.warning.StockWarningParams;
import com.qiho.center.biz.service.warning.StockWarningService;
import com.qiho.center.common.daoh.qiho.StockWarningMapper;
import com.qiho.center.common.entityd.qiho.StockWarningEntity;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * Created by weny.cai on 2018/1/15.
 */
@Service
public class StockWarningServiceImpl implements StockWarningService {

    @Resource
    StockWarningMapper stockWarningMapper;

    @Override
    public PagenationDto<StockWarningDto> queryByParam(StockWarningParams params) {
        List<StockWarningEntity> entities = stockWarningMapper.selectByParam(params);
        int count = stockWarningMapper.selectCountByParam(params);
        PagenationDto<StockWarningDto> pagenationDto = new PagenationDto<>();
        pagenationDto.setTotal(count);
        pagenationDto.setList(BeanUtils.copyList(entities,StockWarningDto.class));
        return pagenationDto;
    }


}
