/**
 * Project Name:qiho-center-biz File Name:LogisticsQueryDecider.java Package Name:com.qiho.center.biz.service.logistics
 * Date:2017年8月10日下午3:22:00 Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package com.qiho.center.biz.service.logistics;

import java.util.EnumMap;

import org.springframework.stereotype.Component;

import com.qiho.center.api.enums.LogisticsNameEnum;
import com.qiho.center.api.exception.QihoException;

/**
 * ClassName:LogisticsQueryDecider <br/>
 * 物流查询处理器决策. <br/>
 * Date: 2017年8月10日 下午3:22:00 <br/>
 * 
 * @author zhanglihui
 * @version
 * @since JDK 1.6
 * @see
 */
@Component
public class LogisticsQueryDecider {

    private static EnumMap<LogisticsNameEnum, LogisticsQueryProcessor> logisticsQueryMap = new EnumMap<>(LogisticsNameEnum.class);

    /**
     * @param logisticsName
     * @return LogisticsQueryProcessor
     */
    public LogisticsQueryProcessor decideLogisticsQueryProcessor(LogisticsNameEnum logisticsName) {
        return logisticsQueryMap.get(logisticsName);
    }

    /**
     * 用于物流信息查询processor注入，在spring初始化时被注入
     * 
     * @param logisticsName
     * @param logisticsQueryProcessor
     */
    public static void registLogisticsQueryProcessor(LogisticsNameEnum logisticsName, LogisticsQueryProcessor logisticsQueryProcessor) {
        if (logisticsName == null || logisticsQueryProcessor == null) {
            throw new QihoException("registLogisticsQueryProcessor 时参数出现null");
        }
        logisticsQueryMap.put(logisticsName, logisticsQueryProcessor);
    }
}
