package com.qiho.center.biz.service.menu;

import cn.com.duiba.boot.exception.BizException;
import com.qiho.center.api.dto.menu.AccountMenuDto;
import com.qiho.center.api.params.menu.AccountMenuParams;

import java.util.List;

/**
 * 菜单接口
 *
 * @author zhangshun
 * @version V1.0
 * @since 2017-12-07 16:21
 */
public interface AccountMenuService {

    /**
     * 批量保存菜单
     *
     * @param accountId
     * @param accountType
     * @param accountName
     * @param menuIdList
     * @return
     */
    Boolean saveAccountMenuList(Long accountId, Integer accountType, String accountName, List<Long> menuIdList)
        throws BizException;

    /**
     * 修改菜单
     *
     * @param accountId
     * @param accountType
     * @param accountName
     * @param menuIdList
     * @return
     */
    Boolean updateAccountMenuList(Long accountId, Integer accountType, String accountName, List<Long> menuIdList)
        throws BizException;

    /**
     * 根据用户ID删除菜单
     *
     * @param accountId
     * @param accountType
     * @param accountName
     * @return
     */
    Integer deleteByAccountId(Long accountId, Integer accountType, String accountName) throws BizException;

    /**
     * 条件查询
     *
     * @return
     * @throws cn.com.duiba.boot.exception.BizException
     */
    List<AccountMenuDto> findAll() throws BizException;

    /**
     * 条件查询 返回 tree
     *
     * @param params
     * @return
     * @throws cn.com.duiba.boot.exception.BizException
     */
    List<AccountMenuDto> findByParamAsTree(AccountMenuParams params) throws BizException;

    /**
     * 用户菜单是有操作权限
     *
     * @param accountId 用户id
     * @param menuId    菜单id
     * @return
     * @throws cn.com.duiba.boot.exception.BizException
     */
    boolean isOperationByAccountIdAndMenuId(Long accountId, Integer accountType, Long menuId);

    /**
     * 根据用户查询，左边菜单栏
     * 新接口请调用 getMenuListByAccountTypeAsTree()
     *
     * @param accountId
     * @return
     * @throws cn.com.duiba.boot.exception.BizException
     */
    List<AccountMenuDto> findByAccountId(Long accountId, Integer accountType) throws BizException;

}
