package com.qiho.center.biz.service.merchant;

import com.qiho.center.api.dto.merchant.MerchantAdvertDto;
import com.qiho.center.api.enums.merchant.BaiqiMerchantLinkTypeEnum;
import com.qiho.center.common.entityd.qiho.merchant.BaiqiMerchantLinkEntity;

import java.util.List;

/**
 * @author peanut.huang
 * @date 2017/12/27.
 */
public interface BaiqiMerchantLinkService {

    /**
     * 批量插入
     *
     * @param insertEntityList
     */
    void batchInsertTuiaLink(List<BaiqiMerchantLinkEntity> insertEntityList);

    /**
     * 根据关联查询
     *
     * @param relationType 关联类型 {@link BaiqiMerchantLinkTypeEnum#type}
     * @param relationId   关联id
     * @return
     */
    BaiqiMerchantLinkEntity findByRelation(Integer relationType, Long relationId);

    /**
     * 根据类型查询
     *
     * @param typeEnum
     * @return
     */
    List<BaiqiMerchantLinkEntity> findByType(BaiqiMerchantLinkTypeEnum typeEnum);

    /**
     * 根据类型查询已关联的数据
     *
     * @param typeEnum
     * @return
     */
    List<BaiqiMerchantLinkEntity> findByTypeWithLinked(BaiqiMerchantLinkTypeEnum typeEnum);

    /**
     * 查询所有商家，包括未与广告主做关联的商家
     *
     * @param merchantId 商家id 精准查询
     * @return
     */
    List<MerchantAdvertDto> findAllWithUnlinked(Long merchantId);

    /**
     * insert
     *
     * @param merchantAdvertDto
     * @return
     */
    Boolean insert(MerchantAdvertDto merchantAdvertDto);

    /**
     * 根据商家和类型查询广告主ID
     *
     * @param merchantId   商家ID
     * @param relationType 类型值
     * @param merchantId
     * @return
     */
    Long findRelationIdByMerchantIdAndRelationType(Long merchantId, BaiqiMerchantLinkTypeEnum relationType);

}
