package com.qiho.center.biz.service.merchant;

import cn.com.duiba.boot.exception.BizException;
import com.qiho.center.api.dto.OpenInterfaceDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.merchant.MerchantDto;
import com.qiho.center.api.dto.merchant.MerchantSimpleDto;
import com.qiho.center.api.dto.merchant.MerchantSpacialDto;
import com.qiho.center.api.params.MerchantQueryParams;
import com.qiho.center.api.params.OpenInterfaceQueryParams;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @author chensong
 * @create 2017-11-15 10:52
 **/
public interface MerchantService {

    /**
     * 根据Id获取商家
     * @param merchantId
     * @return
     */
    MerchantDto findById(Long merchantId);

    /**
     * 新建 或 更新商家信息
     * @param dto
     * @return 受影响行数
     */
    Boolean saveMerchant(MerchantDto dto) throws BizException;

    /**
     * 分页查询商家信息
     * @param params
     * @return
     */
    PagenationDto<MerchantDto> queryPage(MerchantQueryParams params);

    /**
     * 根据商家名称 半模糊匹配
     * @param name
     * @return
     */
    List<MerchantDto> findByName(String name);

    /**
     * 根据商品id获取商家信息
     * @param itemId
     * @return
     */
    MerchantDto findByItemId(Long itemId);


    Map<Long, MerchantDto> findByIdList(List<Long> idList);

    /**
     * 查询所有商家的id和名称
     *
     * @return
     */
    List<MerchantSimpleDto> findAllIdAndNames();

    /**
     * 查询所有商家的id和名称
     *
     * @return
     */
    List<MerchantSimpleDto> findIdAndNamesByIds(List<Long> ids);

    /**
     * 获取所有商家
     * @return 集合
     */
    List<MerchantSpacialDto> findAll();

    /**
     * 获取本地缓存中所有的商家Id-商家名称,缓存时间5min
     * @return
     */
    Map<Long, String> fetchNamesWithCache();

    /**
     *  根据idList批量获取缓存中的商家Id-商家名称,若id不存在，返回null
     * @param idSet
     * @return
     */
    Map<Long, String> fetchNamesWithCache(Set<Long> idSet);


    /**
     * 分页查询商家信息
     *
     * @param params
     *
     * @return
     */
    PagenationDto<OpenInterfaceDto> openInterfacePageQuery(OpenInterfaceQueryParams params);

    /**
     * 保存对外开放商家验证信息
     *
     * @param dto
     *
     * @return
     */
    Boolean saveOpenInterface(OpenInterfaceDto dto);

    /**
     * 根据商家id 获取对外接口信息
     *
     * @param merchantId
     *
     * @return
     */
    OpenInterfaceDto findByMerchantId(Long merchantId);

    /**
     * 根据appKey获取对外接口信息
     *
     * @param appKey
     *
     * @return
     */
    OpenInterfaceDto findByAppKey(String appKey);

    /**
     * 根据商家名称模糊查询
     *
     * @param merchantName
     *
     * @return
     */
    List<MerchantSimpleDto> findNoOpenInterface(String merchantName);

    /**
     * 初始化对外开放商家验证信息
     *
     * @param dto
     *
     * @return
     */
    Boolean updateOpenInterface(OpenInterfaceDto dto);

    /**
     * 查询已存在验证信息的商家总数
     */
    Integer findHasAppKeyCount();

    /**
     * 验证信息
     * @param appKey
     * @param appSecret
     * @return
     */
    OpenInterfaceDto checkedAppKey(String appKey, String appSecret);

    /**
     * 更新商家版本
     * @param versionSign
     * @param id
     * @return
     */
    boolean updateVersionSign(String versionSign,Long id);

}
