package com.qiho.center.biz.service.merchant;

import com.qiho.center.api.dto.merchant.MerchantUndeliveryDto;
import com.qiho.center.api.params.merchant.MerchantUndeliveryQueryParams;
import com.qiho.center.common.entityd.qiho.merchant.BaiqiMerchantUndeliveryEntity;

import java.util.List;

/**
 * 商家不配送区域服务
 *
 * @author peanut.huang
 * @date 2018/1/10.
 */
public interface MerchantUndeliveryService {

    /**
     * 根据参数查询列表
     *
     * @param queryParams  查询参数
     * @return
     */
    List<MerchantUndeliveryDto> findByParams(MerchantUndeliveryQueryParams queryParams);

    /**
     * 根据参数查询总数
     *
     * @param queryParams 查询参数
     * @return
     */
    int countByParams(MerchantUndeliveryQueryParams queryParams);

    /**
     * 根据id集删除
     *
     * @param idList id集
     * @return
     */
    Boolean deleteByIds(List<Long> idList);

    /**
     * 批量插入
     *
     * @param undeliveryList  实体集
     * @return
     */
    Boolean batchInsert(List<BaiqiMerchantUndeliveryEntity> undeliveryList);

    /**
     * 查询商家不配送地区
     *
     * @param merchantId   商家id
     * @return             商家不配送地区代码集
     */
    List<String> findUndelivery(Long merchantId);
}
