package com.qiho.center.biz.service.page;

import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.page.BaiqiPageDto;

/**
 * @author peanut.huang
 * @date 2018/2/23.
 */
public interface BaiqiPageService {

    /**
     * 保存百奇页面
     *
     *   当pageDto 中id不为null ： update
     *   当pageDto 中id为null ： insert
     *
     * @param pageDto     页面实体
     * @return            页面id
     */
    Long savePage(BaiqiPageDto pageDto);

    /**
     * 分页查询页面
     *
     * @param pageName    页面名称
     * @param pageType    页面类型
     * @param offset      偏移量
     * @param pageSize    每页条数
     * @return
     */
    PagenationDto<BaiqiPageDto> find4Paging(String pageName, Integer pageType, Integer offset, Integer pageSize);

    /**
     * 根据页面id获取页面地址
     *
     * @param pageId    页面id
     * @return          页面地址
     */
    String findPageUrl(Long pageId);

    /**
     * 根据页面id获取页面文件md5
     *
     * <p>用以判断页面文件代码是否更新</p>
     *
     * @param pageId   页面id
     * @return         页面文件md5值
     */
    String findPageMd5(Long pageId);

    /**
     * 根据页面id查询页面信息
     *
     * @param pageId  页面id
     * @return        页面信息
     */
    BaiqiPageDto findById(Long pageId);}
