package com.qiho.center.biz.service.page.impl;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.abtest.TestMetadataDto;
import com.qiho.center.api.dto.page.BaiqiPageDto;
import com.qiho.center.api.enums.MetadataTypeEnum;
import com.qiho.center.biz.service.abtest.TestMetadataService;
import com.qiho.center.biz.service.impl.SkinServiceImpl;
import com.qiho.center.biz.service.page.BaiqiPageService;
import com.qiho.center.common.constant.DsConstants;
import com.qiho.center.common.daoh.qiho.QihoTestMetadataMapper;
import com.qiho.center.common.daoh.qiho.page.BaiqiPageMapper;
import com.qiho.center.common.entityd.qiho.abtest.QihoTestMetadataEntity;
import com.qiho.center.common.entityd.qiho.page.BaiqiPageEntity;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * @author peanut.huang
 * @date 2018/2/23.
 */
@Service
public class BaiqiPageServiceImpl implements BaiqiPageService{

    private final static Logger LOGGER = LoggerFactory.getLogger(BaiqiPageServiceImpl.class);
    @Resource
    private BaiqiPageMapper baiqiPageMapper;

    @Resource
    QihoTestMetadataMapper qihoTestMetadataMapper;

    @Resource
    private TestMetadataService testMetadataService;

    @Override
    @Transactional(value = DsConstants.DATABASE_QIHO,rollbackFor = Exception.class)
    public Long savePage(BaiqiPageDto pageDto) {
        BaiqiPageEntity pageEntity = BeanUtils.copy(pageDto, BaiqiPageEntity.class);
        if(pageEntity == null){
            return null;
        }

        //page  id
        Long pageId = pageEntity.getId();

        if(pageId == null){
            //insert

            // 新增到ABTest的meta表中
            try {
                baiqiPageMapper.insert(pageEntity);
                TestMetadataDto testMetadataDto = new TestMetadataDto();
                testMetadataDto.setItemId(0L);
                testMetadataDto.setMetadataKey(MetadataTypeEnum.SKIN.getCode());
                testMetadataDto.setMetadataValue(pageEntity.getId().toString());
                testMetadataDto.setDataName(pageEntity.getPageName());
                testMetadataDto.setDataDesc(pageEntity.getPageName());
                testMetadataDto.setSkinType(1);
                testMetadataService.saveMetadata(testMetadataDto);
            } catch (Exception e) {
                LOGGER.error("BaiqiPageServiceImpl savePage call saveMetadata error,param={}", JSON.toJSONString(pageEntity), e);
            }
            return pageEntity.getId();
        }else {
            //update

            try {
                baiqiPageMapper.update(pageEntity);
                TestMetadataDto testMetadataDto = new TestMetadataDto();
                testMetadataDto.setMetadataKey(MetadataTypeEnum.SKIN.getCode());
                testMetadataDto.setMetadataValue(pageEntity.getId().toString());
                testMetadataDto.setDataName(pageEntity.getPageName());
                testMetadataDto.setDataDesc(pageEntity.getPageName());
                testMetadataDto.setSkinType(1);

                Map<String,Object> map = Maps.newHashMap();
                map.put("metadataKey",MetadataTypeEnum.SKIN.getCode());
                map.put("metadataValue",pageEntity.getId().toString());
                map.put("skinType",1);
                List<QihoTestMetadataEntity> entityList = qihoTestMetadataMapper.selectListByField(map);
                // 判断新皮肤更新的时候，ABTest的元数据表中是否已经存在数据，为了迁移之前没在元数据表中的数据
                if(CollectionUtils.isEmpty(entityList)){
                    testMetadataDto.setItemId(0L);
                    testMetadataService.saveMetadata(testMetadataDto);
                }else {
                    testMetadataService.updateMetadata(testMetadataDto);
                }
            } catch (Exception e) {
                LOGGER.error("BaiqiPageServiceImpl savePage call saveMetadata error,param={}", JSON.toJSONString(pageEntity), e);
            }
            return pageId;
        }
    }

    @Override
    public PagenationDto<BaiqiPageDto> find4Paging(String pageName, Integer pageType, Integer offset, Integer pageSize) {

        //查询数据
        List<BaiqiPageEntity> pageList = baiqiPageMapper.find4Paging(pageName, pageType, offset, pageSize);
        if(CollectionUtils.isEmpty(pageList)){
            return new PagenationDto<>();
        }

        //查询总数
        int count = baiqiPageMapper.count4Paging(pageName, pageType);

        //返回结果
        PagenationDto<BaiqiPageDto> pagenation = new PagenationDto<>();

        pagenation.setList(transToDto(pageList));
        pagenation.setTotal(count);

        return pagenation;
    }

    @Override
    public String findPageUrl(Long pageId) {
        if(pageId == null){
            return null;
        }
        return baiqiPageMapper.findPageUrl(pageId);
    }

    @Override
    public String findPageMd5(Long pageId) {
        if(pageId == null){
            return null;
        }

        return baiqiPageMapper.findPageMd5(pageId);
    }

    @Override
    public BaiqiPageDto findById(Long pageId) {
        if(pageId == null || pageId <= 0){
            return null;
        }

        BaiqiPageEntity pageEntity = baiqiPageMapper.findById(pageId);
        return BeanUtils.copy(pageEntity, BaiqiPageDto.class);
    }

    private List<BaiqiPageDto> transToDto(List<BaiqiPageEntity> pageList) {
        return BeanUtils.copyList(pageList, BaiqiPageDto.class);
    }
}
