package com.qiho.center.biz.service.tag;

import com.qiho.center.api.dto.ResultDto;
import com.qiho.center.api.dto.tag.TagDto;

import java.util.List;

/** 商品标签相关接口
 * @author chensong
 * @create 2018-03-26 17:17
 **/
public interface ItemTagService {

    /**
     * 根据itemId查找商品关联的标签
     * @param itemId
     * @return
     */
    List<TagDto> findByItemId(Long itemId);

    /**
     * 保存商品标签关系
     * @param itemId
     * @param tagIds
     * @return
     */
    ResultDto<Boolean> saveItemTag(Long itemId, List<Long> tagIds);

    /**
     * 此方法用于复制商品时复制原商品关联的标签
     * @param originItemId
     * @param newItemId
     * @return
     */
    Boolean copyItemTag(Long originItemId, Long newItemId);

    /**
     * 根据商品id删除关系
     * @param itemId
     * @return
     */
    Boolean deleteByItemId(Long itemId);

    /**
     * 根据商品id批量删除
     * @param itemIdList
     * @return
     */
    Boolean batchDeleteByItemId(List<Long> itemIdList);

}
