package com.qiho.center.biz.task;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.alibaba.dubbo.common.utils.ConcurrentHashSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qiho.center.api.dto.order.BatchOrderConfirmDto;
import com.qiho.center.biz.bo.domain.LogisticsOrderDo;
import com.qiho.center.biz.event.KuaiDi100Event;
import com.qiho.center.biz.service.OSSFileService;
import com.qiho.center.biz.service.logistics.LogisticsService;
import com.qiho.center.biz.task.bo.OrderConfirmDo;
import com.qiho.center.biz.task.to.OrderConfirmTo;
import com.qiho.center.common.dao.QihoErpOrderDAO;
import com.qiho.center.common.daoh.qiho.OrderConfirmTaskDetailMapper;
import com.qiho.center.common.daoh.qiho.OrderConfirmTaskMapper;
import com.qiho.center.common.daoh.qiho.OrderSnapshotMapper;
import com.qiho.center.common.entity.order.QihoErpOrderEntity;
import com.qiho.center.common.entityd.qiho.OrderConfirmTaskDetailEntity;
import com.qiho.center.common.entityd.qiho.OrderConfirmTaskEntity;
import com.qiho.center.common.entityd.qiho.OrderSnapshotEntity;
import com.qiho.center.common.entityd.qiho.logistics.BaiqiLogisticsEntity;
import com.qiho.center.common.support.BizEventBus;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Scope;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.*;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * Created by weny.cai on 2018/3/21.
 */
@Component
@Scope("prototype")
public class BatchOrderTask implements Runnable{

    private Logger logger = LoggerFactory.getLogger(BatchOrderTask.class);

    private static final ExecutorService executorService = new ThreadPoolExecutor(20, 35, 0L,
        TimeUnit.MILLISECONDS, new LinkedBlockingQueue(200));

    @Autowired
    LogisticsService logisticsService;

    @Autowired
    OrderSnapshotMapper orderSnapshotMapper;

    @Autowired
    OSSFileService ossFileService;

    BatchOrderConfirmDto dto;

    OrderConfirmTaskEntity taskEntity;

    List<OrderConfirmTaskDetailEntity> detailEntities = Lists.newArrayList();

    List<LogisticsOrderDo> logisticsOrderDos = Lists.newArrayList();

    @Autowired
    OrderConfirmTaskMapper orderConfirmTaskMapper;

    @Autowired
    OrderConfirmTaskDetailMapper orderConfirmTaskDetailMapper;

    @Autowired
    StringRedisTemplate redisTemplate;

    @Autowired
    private ApplicationContext context;

    @Autowired
    private BizEventBus eventBus;

    @Autowired
    private QihoErpOrderDAO qihoErpOrderDAO;

    BoundHashOperations<String, String, String> ops;

    LinkedBlockingQueue<OrderConfirmDo> blockingQueue = new LinkedBlockingQueue();

    Map<String, OrderSnapshotEntity> entityMap;

    Map<String,QihoErpOrderEntity> erpOrderEntityMap;

    final ConcurrentHashSet<Integer> failLines = new ConcurrentHashSet<>();

    long startTime;

    AtomicInteger failNum = new AtomicInteger(0);

    List<OrderConfirmDo> dos = null;

    BaiqiLogisticsEntity logisticsEntity = null;


    @Override
    public void run() {
        //获取集合
        if(dto.getTaskType()<=2){
            this.getOrderDosByExcel();
        }
        //更新任务状态
        this.updateTask();

        //校验参数  重复的订单列为失败
        checkDos();
        if(!dos.isEmpty()){
            //获取订单map 用于处理
            getStringOrderSnapshotEntityMap();
            //批量处理 订单数据
            this.handlerBos();
        }
        //最后处理的结果 存入数据库
        this.handlerResult();
    }


    private void checkDos() {
        List<OrderConfirmDo> list = Lists.newArrayList();
        List<String> maps = Lists.newArrayList();
        for (OrderConfirmDo aDo : dos) {
            //如果已经包含订单ID 列为重复 并不加入处理集合
            if(StringUtils.isNotBlank(aDo.getOrderId())&&maps.contains(aDo.getOrderId())){
                OrderConfirmTaskDetailEntity detailEntity = new OrderConfirmTaskDetailEntity();
                detailEntity.setOrderId(aDo.getOrderId());
                detailEntity.setOrderConfirmTaskId(taskEntity.getId());
                detailEntity.setPostId(aDo.getPostId());
                detailEntity.setLineNum(aDo.getLineNum());
                detailEntity.setFailMsg("订单ID重复");
                detailEntities.add(detailEntity);
                failLines.add(aDo.getLineNum());
                failNum.addAndGet(1);
                ops.increment("handleCount", 1);
                continue;
            }
            maps.add(aDo.getOrderId());
            list.add(aDo);
        }
        this.dos = list;
    }

    public void init(BatchOrderConfirmDto batchOrderConfirmDto,OrderConfirmTaskEntity taskEntity){
        this.dto = batchOrderConfirmDto;
        ops = redisTemplate.boundHashOps(dto.getTaskId());
        this.startTime = System.currentTimeMillis();
        this.taskEntity = taskEntity;
    }

    public void init(BatchOrderConfirmDto batchOrderConfirmDto,OrderConfirmTaskEntity taskEntity,List<OrderConfirmDo> dos){
        this.dos = dos;
        this.dto = batchOrderConfirmDto;
        ops = redisTemplate.boundHashOps(dto.getTaskId());
        this.startTime = System.currentTimeMillis();
        this.taskEntity = taskEntity;
    }


    public void handlerBos() {
        try {
            blockingQueue.addAll(dos);
            dos.clear();
            //启动五个线程处理数据 处理集合
            CountDownLatch countDownLatch = new CountDownLatch(5);
            for (int i = 0; i < 5; i++) {
                OrderBoRunnable boRunnable = null;
                if(dto.getTaskType()==0||dto.getTaskType()==3){
                    boRunnable = context.getBean(OrderConfirmBoRunnable.class,this,countDownLatch);
                }
                if(dto.getTaskType()==1||dto.getTaskType()==4){
                    boRunnable = context.getBean(OrderUpdateBoRunnable.class,this,countDownLatch);
                }
                executorService.submit(boRunnable);
            }
            countDownLatch.await();
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    /**
     * updateTask 插入数据库
     */
    public void updateTask() {
        ops.put("totalCount", String.valueOf(dos.size()));
        ops.put("status","handling");
        taskEntity.setAllNum(dos.size());
        taskEntity.setLogisticsCode(dto.getExpress());
        if(dos.size()==0){
            this.taskEntity.setTaskStatus(1);
        }else{
            this.taskEntity.setTaskStatus(0);
        }
        orderConfirmTaskMapper.updateByPrimaryKeySelective(taskEntity);
    }

    /**
     * 读取文件
     * 转化为集合
     * @return
     */
    public void getOrderDosByExcel() {
        logisticsEntity = logisticsService.findByCode(dto.getExpress());
        InputStream input = ossFileService.getOssFileInputStream(dto.getFileUrl());
        ImportParams params = new ImportParams();
        String[] importFields = {"订单ID","物流单号"};
        params.setImportFields(importFields);
        params.setKeyIndex(null);
        List<OrderConfirmTo> list = Lists.newArrayList();
        try {
            list = ExcelImportUtil.importExcel(input, OrderConfirmTo.class, params);
        } catch (Exception e) {
            logger.warn("导入文件的表头格式不正确!");
        }
        List<OrderConfirmDo> dos = Lists.newArrayList();
        for (OrderConfirmTo orderConfirmTo : list) {
            if(StringUtils.isBlank(orderConfirmTo.getOrderId())
                &&StringUtils.isBlank(orderConfirmTo.getPostId())){
                continue;
            }
            OrderConfirmDo orderConfirmDo = BeanUtils.copy(orderConfirmTo,OrderConfirmDo.class);
            orderConfirmDo.setLogisticsCode(logisticsEntity.getLogisticsCode());
            orderConfirmDo.setLogisticsName(logisticsEntity.getLogisticsName());
            orderConfirmDo.setMerchantId(dto.getMerchantId());
            orderConfirmDo.setLineNum(orderConfirmTo.getRowNum());
            if(StringUtils.isNotBlank(orderConfirmDo.getOrderId())){
                orderConfirmDo.setOrderId(orderConfirmDo.getOrderId().trim());
            }
            if(StringUtils.isNotBlank(orderConfirmDo.getPostId())){
                orderConfirmDo.setPostId(orderConfirmDo.getPostId().trim());
            }
            dos.add(orderConfirmDo);
        }
        this.dos = dos;
    }

    /**
     * 从数据库中
     * 获取存在的订单
     * @return
     */
    public void getStringOrderSnapshotEntityMap() {
        List<String> orderIds = Lists.newArrayList();
        for (OrderConfirmDo orderConfirmBo : dos) {
            orderIds.add(orderConfirmBo.getOrderId());
        }
        //数据库中查询所有订单数据  转化为map
        List<OrderSnapshotEntity> entities = orderSnapshotMapper.selectByOrderIds(orderIds);
        Map<String,OrderSnapshotEntity> entityMap = Maps.newHashMap();
        for (OrderSnapshotEntity entity : entities) {
            entityMap.put(entity.getOrderId(),entity);
        }

        List<QihoErpOrderEntity> erpOrderEntities = qihoErpOrderDAO.findByOrderIds(orderIds);
        Map<String,QihoErpOrderEntity> erpMaps = Maps.newHashMap();
        for (QihoErpOrderEntity entity : erpOrderEntities) {
            erpMaps.put(entity.getOrderId(),entity);
        }

        this.erpOrderEntityMap = erpMaps;
        this.entityMap = entityMap;
    }

    /**
     * 处理最后的结果
     */
    public void handlerResult() {
        ops.put("status","over");
        ops.put("failLines",StringUtils.join(failLines.iterator(), ","));
        ops.put("failNum",String.valueOf(failNum.intValue()));
        //批量插入处理结果
        if(!detailEntities.isEmpty()){
            orderConfirmTaskDetailMapper.batchInsert(detailEntities);
        }
        this.taskEntity.setConsumeTime(System.currentTimeMillis()-this.startTime);
        this.taskEntity.setFailNum(failNum.intValue());
        this.taskEntity.setTaskStatus(1);
        orderConfirmTaskMapper.updateByPrimaryKeySelective(taskEntity);
        //处理更新快递100事件
        if(!logisticsOrderDos.isEmpty()){
            KuaiDi100Event event = new KuaiDi100Event();
            event.setLogisticsOrderDos(logisticsOrderDos);
            eventBus.post(event);
        }
    }

    public LinkedBlockingQueue<OrderConfirmDo> getBlockingQueue() {
        return blockingQueue;
    }

    public Map<String, OrderSnapshotEntity> getEntityMap() {
        return entityMap;
    }

    public Map<String, QihoErpOrderEntity> getErpOrderEntityMap() {
        return erpOrderEntityMap;
    }

    public OrderConfirmTaskEntity getTaskEntity() {
        return taskEntity;
    }

    public synchronized void addDetailEntity(OrderConfirmTaskDetailEntity detailEntity){
        detailEntities.add(detailEntity);
    }

    public synchronized void addLogistics(LogisticsOrderDo logisticsOrderDo){
        logisticsOrderDos.add(logisticsOrderDo);
    }

}
