package com.qiho.center.biz.task;

import com.qiho.center.api.enums.OrderStatusEnum;
import com.qiho.center.biz.bo.OrderLogisticBo;
import com.qiho.center.biz.bo.domain.LogisticsOrderDo;
import com.qiho.center.biz.task.bo.OrderConfirmDo;
import com.qiho.center.common.entity.order.QihoErpOrderEntity;
import com.qiho.center.common.entityd.qiho.OrderConfirmTaskDetailEntity;
import com.qiho.center.common.entityd.qiho.OrderSnapshotEntity;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import java.util.concurrent.CountDownLatch;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Created by weny.cai on 2018/3/29.
 */
@Component
@Scope("prototype")
public class OrderUpdateBoRunnable extends OrderBoRunnable{

    private final Logger logger = LoggerFactory.getLogger(OrderUpdateBoRunnable.class);

    private static final String NUM_AND_LETTER_REG_EX = "^[A-Za-z0-9]{1,40}$";

    @Autowired
    OrderLogisticBo orderLogisticBo;

    public OrderUpdateBoRunnable(BatchOrderTask batchOrderTask, CountDownLatch countDownLatch) {
        super(batchOrderTask, countDownLatch);
    }

    @Override
    boolean checkParam(OrderConfirmDo confirmDo, OrderSnapshotEntity orderSnapshotEntity) {
        this.detailEntity = new OrderConfirmTaskDetailEntity();
        detailEntity.setOrderId(confirmDo.getOrderId());
        detailEntity.setOrderConfirmTaskId(task.taskEntity.getId());
        detailEntity.setPostId(confirmDo.getPostId());
        detailEntity.setLineNum(confirmDo.getLineNum());
        if("ERROR_CELL".equals(confirmDo.getPostId())||"ERROR_CELL".equals(confirmDo.getOrderId())){
            detailEntity.setOrderId("");
            detailEntity.setFailMsg("错误的单元格");
            return false;
        }

        if(orderSnapshotEntity == null){
            detailEntity.setFailMsg("订单ID不存在!");
            return false;
        }

        //订单必须处于待发货状态
        if(!OrderStatusEnum.SEND_OUT.getCode().equals(orderSnapshotEntity.getOrderStatus())){
            detailEntity.setFailMsg("订单非已发货状态!");
            return false;
        }

        //格式不完整 不处理 返回失败
        if (StringUtils.isBlank(confirmDo.getPostId()) || StringUtils.isBlank(confirmDo.getOrderId()) ) {
            detailEntity.setFailMsg("订单ID或物流单号为空!");
            return false;
        }

        // 验证物流信息
        if (StringUtils.isBlank(confirmDo.getLogisticsCode()) || StringUtils.isBlank(confirmDo.getLogisticsName())) {
            detailEntity.setFailMsg("物流编码有误!");
            return false;
        }

        // 忽略大小写的写法
        Pattern pat = Pattern.compile(NUM_AND_LETTER_REG_EX, Pattern.CASE_INSENSITIVE);
        Matcher matcher = pat.matcher(confirmDo.getPostId().trim());
        // 字符串是否与正则表达式相匹配
        boolean rs = matcher.matches();
        if (!rs) {//数字和字母的检验
            detailEntity.setFailMsg("物流单号格式有误!");
            return false;
        }

        //-1奇货后台传的数据 不进行商家校验
        if(confirmDo.getMerchantId()== -1){
            return true;
        }

        //对商家进行校验 操作权限
        if (!confirmDo.getMerchantId().equals(orderSnapshotEntity.getMerchantId())) {
            detailEntity.setFailMsg("不属于导入的商家!");
            return false;
        }
        return true;
    }

    @Override
    void auditOrder(OrderConfirmDo confirmDo, OrderSnapshotEntity orderSnapshotEntity,QihoErpOrderEntity erpOrderEntity) {
        orderLogisticBo.updateLogistics(confirmDo.getLogisticsCode(),
            confirmDo.getLogisticsName(),confirmDo.getPostId(),confirmDo.getOrderId());
        LogisticsOrderDo logisticsOrderDo = new LogisticsOrderDo();
        logisticsOrderDo.setPostId(confirmDo.getPostId());
        logisticsOrderDo.setLogisticsCode(confirmDo.getLogisticsCode());
        task.addLogistics(logisticsOrderDo);
    }
}
