package com.qiho.center.biz.util;

import com.qiho.center.biz.model.SsjxAddressBean;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by sunchangji on 2018/1/17.
 */
public class QihoStringUtil {

    private QihoStringUtil(){

    }

    /**
     * 去除空字符串
     * @param parmas
     * @return
     */
    public static List<String> excludeNullString(String... parmas){
        List<String> strList = new ArrayList<>();
        for(String param : parmas){
            if(StringUtils.isNotBlank(param)){
                strList.add(param);
            }
        }

        return strList;
    }

    /**
     * sendTime类似于：6adn7,1_2_6_9(逗号之前是配送时间,逗号之后是省市区镇对应的盛世嘉祥省市区记录id)
     * @param sendTime
     * @return
     */
    public static SsjxAddressBean analyzeSendTime(String sendTime){
        if(StringUtils.isEmpty(sendTime)){
            return null;
        }
        SsjxAddressBean addressBean = new SsjxAddressBean();
        String[] sendAndAddrs = sendTime.split(",");
        addressBean.setSendTime(sendAndAddrs[0]);
        if(sendAndAddrs.length == 1){
            return addressBean;
        }
        String addressIds = sendAndAddrs[1];
        String[] addressDetailIds = addressIds.split("_");
        addressBean.setProvince3(addressDetailIds[0]);
        if(addressDetailIds.length == 4){
            addressBean.setCity3(addressDetailIds[1]);
            addressBean.setArea3(addressDetailIds[2]);
            addressBean.setTownship3(addressDetailIds[3]);
            return addressBean;
        }
        if(addressDetailIds.length == 3){
            addressBean.setCity3(addressDetailIds[1]);
            addressBean.setArea3(addressDetailIds[2]);
            return addressBean;
        }
        if(addressDetailIds.length == 2){
            addressBean.setCity3(addressDetailIds[1]);
            return addressBean;
        }

        return null;
    }
}
