/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.bo;

import cn.com.duiba.wolf.utils.DateUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qiho.center.common.daoh.qihostatistics.BaiqiAppOrderMonitorMapper;
import com.qiho.center.common.entity.BaseEntity;
import com.qiho.center.common.entityd.qihostatistics.BaiqiAppOrderMonitorEntity;
import com.qiho.center.common.util.DingTalkUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class AppMonitorBo {
    private static final Logger logger = LoggerFactory.getLogger(AppMonitorBo.class);
    @Autowired
    private BaiqiAppOrderMonitorMapper baiqiAppOrderMonitorMapper;
    @Value(value="${dingtalk.rushorder.url}")
    private String dingTalkRobot;

    public void exeTask() {
        List<BaiqiAppOrderMonitorEntity> orderMonitorList = this.loadData();
        if (CollectionUtils.isEmpty(orderMonitorList)) {
            return;
        }
        this.sendDingTalkMsg(orderMonitorList);
        this.updateWarnStatus(orderMonitorList);
    }

    private List<BaiqiAppOrderMonitorEntity> loadData() {
        Date endTime = new Date();
        Date startTime = DateUtils.hoursAddOrSub((Date)endTime, (int)-2);
        HashMap param = Maps.newHashMap();
        param.put("endTime", endTime);
        param.put("startTime", startTime);
        return this.baiqiAppOrderMonitorMapper.listByParam((Map)param);
    }

    private void sendDingTalkMsg(List<BaiqiAppOrderMonitorEntity> orderMonitorList) {
        HashMap orderMap = Maps.newHashMap();
        for (BaiqiAppOrderMonitorEntity e : orderMonitorList) {
            String key = e.getAppName() + "*" + e.getAppid();
            if (orderMap.get(key) == null) {
                orderMap.put(key, Lists.newArrayList((Object[])new String[]{e.getOrderId()}));
                continue;
            }
            List list = (List)orderMap.get(key);
            list.add(e.getOrderId());
            orderMap.put(key, list);
        }
        StringBuilder msg = new StringBuilder("\u4ee5\u4e0b\u5a92\u4f53\uff1a\n");
        for (String mapKey : orderMap.keySet()) {
            int index = mapKey.indexOf("*");
            msg.append("appId:").append(mapKey.substring(index + 1)).append("\uff0capp\u540d\u79f0:").append(mapKey.substring(0, index)).append("\uff0c\u6709\u7591\u4f3c\u5237\u5355\u884c\u4e3a\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\uff0c\u8ba2\u5355id\u4e3a:").append(((List)orderMap.get(mapKey)).toString()).append("\n");
        }
        DingTalkUtil.sendTextMessageWith((String)msg.toString(), (String)this.dingTalkRobot, (boolean)true);
    }

    private void updateWarnStatus(List<BaiqiAppOrderMonitorEntity> orderMonitorList) {
        List idList = orderMonitorList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        this.baiqiAppOrderMonitorMapper.updateWarnByIds(idList);
    }
}

