/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.bo;

import com.qiho.center.api.dto.agent.BaiqiAgentMerchantDto;
import com.qiho.center.api.dto.merchant.MerchantDto;
import com.qiho.center.api.enums.account.BaiqiAccountTypeEnum;
import com.qiho.center.biz.service.account.BaiqiAccountService;
import com.qiho.center.biz.service.agent.BaiqiAgentMerchantService;
import com.qiho.center.biz.service.merchant.MerchantService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class BaiqiAgentBO {
    @Resource
    private BaiqiAgentMerchantService baiqiAgentMerchantService;
    @Resource
    private MerchantService merchantService;
    @Resource
    private BaiqiAccountService baiqiAccountService;

    public List<BaiqiAgentMerchantDto> findAgentMerchantsById(Long agentId) {
        List<Long> merchantIds = this.baiqiAgentMerchantService.findExistMerchantIds(agentId);
        if (CollectionUtils.isEmpty(merchantIds)) {
            return Collections.emptyList();
        }
        List<Long> filterMerchantIds = this.baiqiAccountService.filterMerchantIds(merchantIds);
        if (CollectionUtils.isEmpty(filterMerchantIds)) {
            return Collections.emptyList();
        }
        Map<Long, MerchantDto> merchantDtoMap = this.merchantService.findByIdList(filterMerchantIds);
        ArrayList<BaiqiAgentMerchantDto> agentMerchantDtos = new ArrayList<BaiqiAgentMerchantDto>(merchantIds.size());
        for (Long merchantId : merchantIds) {
            MerchantDto merchantDto;
            if (!filterMerchantIds.contains(merchantId) || (merchantDto = merchantDtoMap.get(merchantId)) == null) continue;
            BaiqiAgentMerchantDto agentMerchantDto = new BaiqiAgentMerchantDto();
            agentMerchantDto.setAccountType(BaiqiAccountTypeEnum.MAIN_ACCOUNT.getCode());
            agentMerchantDto.setMerchantId(merchantDto.getId());
            agentMerchantDto.setMerchantName(merchantDto.getMerchantName());
            agentMerchantDtos.add(agentMerchantDto);
        }
        return agentMerchantDtos;
    }
}

