/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.bo;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.qiho.center.api.dto.user.WechatUserDto;
import com.qiho.center.api.enums.user.UserTypeEnum;
import com.qiho.center.biz.service.user.BaiqiUserService;
import com.qiho.center.biz.service.user.WechatUserService;
import com.qiho.center.common.entityd.qiho.user.BaiqiUserEntity;
import com.qiho.center.common.entityd.qiho.user.WechatUserEntity;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service
public class BaiqiUserBO {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaiqiUserBO.class);
    @Resource
    private WechatUserService wechatUserService;
    @Resource
    private BaiqiUserService baiqiUserService;

    @Transactional(value="QIHO", rollbackFor={Exception.class})
    public Boolean insertWechatUser(WechatUserDto wechatUserDto) {
        try {
            Long existUserId = this.wechatUserService.findUserIdByMiniOpenId(wechatUserDto.getMiniOpenId());
            if (existUserId == null) {
                BaiqiUserEntity userEntity = new BaiqiUserEntity();
                userEntity.setSourceType(Integer.valueOf(UserTypeEnum.WECHAT.getValue()));
                userEntity.setMobile(wechatUserDto.getMobile());
                this.baiqiUserService.insert(userEntity);
                Long newUserId = userEntity.getId();
                WechatUserEntity wechatUserEntity = (WechatUserEntity)BeanUtils.copy((Object)wechatUserDto, WechatUserEntity.class);
                wechatUserEntity.setUserId(newUserId);
                this.wechatUserService.insertUser(wechatUserEntity);
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.error("insert wechat user faild", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return false;
        }
    }
}

