/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.bo;

import cn.com.duiba.stock.service.api.remoteservice.RemoteStockBackendService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.qiho.center.biz.model.EdbItemStockResponse;
import com.qiho.center.biz.service.impl.OrderStockService;
import com.qiho.center.common.util.EdbLib;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EdbItemStockBo {
    private static final Logger LOGGER = LoggerFactory.getLogger(EdbItemStockBo.class);
    private static final String PAGE_SIZE = "100";
    @Autowired
    private RemoteStockBackendService remoteStockBackendService;
    @Autowired
    private OrderStockService orderStockService;
    @Autowired
    private EdbLib edbLib;

    public void syncEdbStock() {
        List<EdbItemStockResponse> responses;
        ArrayList increaseStock = Lists.newArrayList();
        ArrayList decreaseStock = Lists.newArrayList();
        int pageNo = 1;
        while (!CollectionUtils.isEmpty(responses = this.edbProductGet(pageNo))) {
            this.orderStockService.handleEdbErpStocks(increaseStock, decreaseStock, responses);
            ++pageNo;
        }
        DubboResult incResult = this.remoteStockBackendService.increaseItemStockBatch((List)increaseStock);
        DubboResult desResult = this.remoteStockBackendService.decreaseItemStockBatch((List)decreaseStock);
        if (!incResult.isSuccess() || !desResult.isSuccess()) {
            LOGGER.warn("\u5e93\u5b58\u540c\u6b65\u5931\u8d25\uff1a{},{}", (Object)incResult.getMsg(), (Object)desResult.getMsg());
        }
    }

    private List<EdbItemStockResponse> edbProductGet(int pageNo) {
        Map params = this.edbLib.edbGetCommonParams("edbProductGet");
        params.put("page_no", String.valueOf(pageNo));
        params.put("page_size", PAGE_SIZE);
        String res = this.edbLib.edbRequstPost(params);
        if (StringUtils.isBlank((CharSequence)res)) {
            return Collections.emptyList();
        }
        JSONObject json = JSONObject.parseObject((String)res);
        JSONObject successList = json.getJSONObject("Success");
        if (successList == null) {
            return Collections.emptyList();
        }
        Integer totalResults = successList.getInteger("total_results");
        if (totalResults == 0) {
            return Collections.emptyList();
        }
        String items = successList.getJSONObject("items").getString("item");
        return JSONObject.parseArray((String)items, EdbItemStockResponse.class);
    }
}

