/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.bo;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.RateLimiter;
import com.qiho.center.api.dto.logistics.LogisticsOrderDto;
import com.qiho.center.api.dto.logistics.LogisticsProcessDto;
import com.qiho.center.api.enums.ExpressBirdLogisticsStatusEnum;
import com.qiho.center.api.enums.ExpressBirdOrderStatusEnum;
import com.qiho.center.api.enums.logistics.LogisticsExpressPlatformEnum;
import com.qiho.center.biz.bo.domain.LogisticsOrderDo;
import com.qiho.center.biz.service.LogisticsOrderService;
import com.qiho.center.biz.service.logistics.ExpressBirdService;
import com.qiho.center.biz.service.logistics.LogisticsService;
import com.qiho.center.biz.service.logistics.LogisticsSubscribeService;
import com.qiho.center.common.entityd.qiho.logistics.BaiqiExpressCodeMappingEntity;
import com.qiho.center.common.entityd.qiho.logistics.BaiqiLogisticsEntity;
import com.qiho.center.common.entityd.qiho.logistics.BaiqiLogisticsSubscribeEntity;
import com.qiho.center.common.params.kuaidiniao.ExpressResult;
import com.qiho.center.common.params.kuaidiniao.ExpressResultItem;
import com.qiho.center.common.util.ExpressBirdUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ExpressBirdBo {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExpressBirdBo.class);
    @Resource
    private ExpressBirdService expressBirdService;
    @Resource
    private LogisticsService logisticsService;
    @Resource
    private LogisticsOrderService logisticsOrderService;
    @Resource
    private LogisticsSubscribeService subscribeService;
    private static RateLimiter rateLimiter = RateLimiter.create((double)30.0, (long)1L, (TimeUnit)TimeUnit.SECONDS);

    public boolean dealExpressBirdStatus(String code, String postId, String status) {
        LOGGER.info("\u5feb\u9012\u9e1f \u63a8\u9001\u4fe1\u606f\uff1a\u5feb\u9012\u516c\u53f8\u7f16\u7801\uff1a{} \uff0c \u5feb\u9012\u5355\u53f7: {} \uff0c\u5feb\u9012\u5355\u5f53\u524d\u72b6\u6001: {}", new Object[]{code, postId, status});
        LogisticsOrderDto dto = new LogisticsOrderDto();
        ExpressBirdLogisticsStatusEnum expressBirdLogisticsStatusEnum = ExpressBirdLogisticsStatusEnum.getByState((String)status);
        if (expressBirdLogisticsStatusEnum != null) {
            dto.setLogisticsStatus(expressBirdLogisticsStatusEnum.getDesc());
        } else {
            dto.setLogisticsStatus(status);
        }
        ExpressBirdOrderStatusEnum orderStatusEnum = ExpressBirdOrderStatusEnum.getByExpressBird((String)status);
        if (orderStatusEnum == null) {
            return true;
        }
        dto.setOrderStatus(orderStatusEnum.getStatus());
        dto.setPostId(postId);
        BaiqiExpressCodeMappingEntity codeMappingEntity = this.expressBirdService.findByBaiqiLogisticsCode(code, LogisticsExpressPlatformEnum.BIRD.getCode());
        if (codeMappingEntity == null) {
            LOGGER.error("\u5feb\u9012100\u63a8\u9001\u7684\u5feb\u9012\u516c\u53f8\u4ee3\u7801\u8868\u4e2d\u4e0d\u5b58\u5728:", (Object)code);
            return false;
        }
        BaiqiLogisticsEntity baiqiLogisticsEntity = this.logisticsService.findById(codeMappingEntity.getLogisticsId());
        if (baiqiLogisticsEntity == null) {
            LOGGER.error("\u5feb\u9012\u9e1f\u63a8\u9001\u7684\u5feb\u9012\u516c\u53f8\u6240\u6620\u5c04\u7684\u767e\u5947\u7269\u6d41\u516c\u53f8\u4e0d\u5b58\u5728:", (Object)codeMappingEntity.getLogisticsId());
            return false;
        }
        dto.setLogisticsCode(baiqiLogisticsEntity.getLogisticsCode());
        this.logisticsOrderService.update(dto);
        return true;
    }

    public void dealPostOrders(List<LogisticsOrderDo> list) {
        List groupList = Lists.partition(list, (int)30);
        for (List listItem : groupList) {
            for (LogisticsOrderDo item : listItem) {
                BaiqiExpressCodeMappingEntity expressLogisticsEntity = this.expressBirdService.findByBaiqiLogisticsCode(item.getLogisticsCode(), LogisticsExpressPlatformEnum.BIRD.getCode());
                if (expressLogisticsEntity == null) {
                    LOGGER.error("\u5728\u5feb\u9012\u9e1f\u5bf9\u5e94\u7684\u7269\u6d41\u4e2d\u4e0d\u5b58\u5728\u767e\u5947\u5feb\u9012\u516c\u53f8\u4ee3\u7801:{}", (Object)item.getLogisticsCode());
                    continue;
                }
                BaiqiLogisticsSubscribeEntity subscribeEntity = new BaiqiLogisticsSubscribeEntity();
                subscribeEntity.setLogisticsCode(expressLogisticsEntity.getLogisticsCode());
                subscribeEntity.setExpressPlatform(LogisticsExpressPlatformEnum.BIRD.getName());
                subscribeEntity.setPostId(item.getPostId());
                this.saveOrder(subscribeEntity);
                rateLimiter.acquire();
                this.postOrder(subscribeEntity);
            }
        }
    }

    private void saveOrder(BaiqiLogisticsSubscribeEntity subscribeEntity) {
        int count = this.subscribeService.countLogisticsSubscribe(subscribeEntity.getPostId());
        if (count <= 0) {
            this.subscribeService.insertLogisticsSubscribe(subscribeEntity);
        }
    }

    private void postOrder(BaiqiLogisticsSubscribeEntity subscribeEntity) {
        boolean flag = ExpressBirdUtil.postOrder((String)subscribeEntity.getLogisticsCode(), (String)subscribeEntity.getPostId());
        if (flag) {
            this.subscribeService.changeLogisticsSubscribe(subscribeEntity);
        }
    }

    public List<LogisticsProcessDto> queryWaybillTrace(String logisticsCode, String postId) {
        if (StringUtils.isBlank((CharSequence)postId)) {
            return Collections.emptyList();
        }
        BaiqiExpressCodeMappingEntity expressLogisticsEntity = this.expressBirdService.findByBaiqiLogisticsCode(logisticsCode, LogisticsExpressPlatformEnum.BIRD.getCode());
        if (expressLogisticsEntity == null) {
            LOGGER.error("\u83b7\u53d6\u4e0d\u5230\u5feb\u9012\u9e1f\u7269\u6d41\u516c\u53f8\u4fe1\u606f");
            return Collections.emptyList();
        }
        ArrayList resultList = null;
        try {
            ExpressResult result = ExpressBirdUtil.queryWaybillTrace((String)expressLogisticsEntity.getLogisticsCode(), (String)postId);
            if (result != null && CollectionUtils.isNotEmpty((Collection)result.getTraces())) {
                List list = result.getTraces();
                resultList = Lists.newArrayListWithCapacity((int)list.size());
                for (ExpressResultItem item : list) {
                    LogisticsProcessDto logisticsProcessDto = new LogisticsProcessDto();
                    logisticsProcessDto.setWaybillNo(postId);
                    logisticsProcessDto.setUploadTime(DateFormatUtils.format((Date)item.getAcceptTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                    logisticsProcessDto.setProcessInfo(item.getAcceptStation());
                    resultList.add(logisticsProcessDto);
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("\u5feb\u9012\u9e1f\u8fd0\u5355\u8d70\u4ef6\u6d41\u7a0b\u5f02\u5e38\uff0c postId = " + postId, (Throwable)e);
        }
        return resultList;
    }
}

