/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.bo;

import com.qiho.center.api.dto.logistics.LogisticsProcessDto;
import com.qiho.center.biz.bo.ExpressBirdBo;
import com.qiho.center.biz.bo.KuaiDi100Bo;
import com.qiho.center.biz.bo.domain.LogisticsOrderDo;
import com.qiho.center.common.constant.ExpressEnvironment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ExpressBo {
    @Autowired
    private KuaiDi100Bo kuaiDi100Bo;
    @Autowired
    private ExpressBirdBo expressBirdBo;

    public void subscribeExpress(List<LogisticsOrderDo> list) {
        if (ExpressEnvironment.isExpressBird()) {
            ArrayList<LogisticsOrderDo> bird = new ArrayList<LogisticsOrderDo>();
            ArrayList hundred = new ArrayList();
            list.forEach(item -> {
                if (this.checkExpress(item.getLogisticsCode())) {
                    bird.add((LogisticsOrderDo)item);
                } else {
                    hundred.add(item);
                }
            });
            if (!bird.isEmpty()) {
                this.expressBirdBo.dealPostOrders(bird);
            }
            if (!hundred.isEmpty()) {
                this.kuaiDi100Bo.dealpostOrders(list);
            }
        } else {
            this.kuaiDi100Bo.dealpostOrders(list);
        }
    }

    public List<LogisticsProcessDto> queryWaybillTrace(String logisticsCode, String postId) {
        if (ExpressEnvironment.isExpressBird() && this.checkExpress(logisticsCode)) {
            List<LogisticsProcessDto> list = this.expressBirdBo.queryWaybillTrace(logisticsCode, postId);
            if (CollectionUtils.isEmpty(list)) {
                return Collections.emptyList();
            }
            Collections.reverse(list);
            return list;
        }
        return this.kuaiDi100Bo.queryWaybillTrace(logisticsCode, postId);
    }

    private boolean checkExpress(String code) {
        return !"BTWL".equals(code) && !"BEST_EX".equals(code) && !"SF".equals(code) && !"DCWL".equals(code);
    }
}

