/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.bo;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.qiho.center.api.dto.ItemDto;
import com.qiho.center.biz.service.ItemRecommendService;
import com.qiho.center.biz.service.ItemService;
import com.qiho.center.common.entity.item.QihoItemRecommendEntity;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ItemRecommendBo {
    @Autowired
    private ItemRecommendService itemRecommendService;
    @Autowired
    private ItemService itemService;

    public List<ItemDto> findRecommendItemList() {
        List<QihoItemRecommendEntity> recommends = this.itemRecommendService.findAllItemRecommend();
        HashMap recommendEntityMap = Maps.newHashMap();
        for (QihoItemRecommendEntity it : recommends) {
            recommendEntityMap.put(it.getItemId(), it);
        }
        List<ItemDto> dtoList = this.itemService.findItemDtoByItemIds(recommendEntityMap.keySet());
        ItemOrdering itemOrdering = new ItemOrdering();
        itemOrdering.setRecommendEntityMap(recommendEntityMap);
        Ordering ordering = Ordering.natural().reverse().onResultOf((Function)itemOrdering);
        return ordering.sortedCopy(dtoList);
    }

    private class ItemOrdering
    implements Function<ItemDto, Integer> {
        private Map<Long, QihoItemRecommendEntity> recommendEntityMap;

        private ItemOrdering() {
        }

        public void setRecommendEntityMap(Map<Long, QihoItemRecommendEntity> recommendEntityMap) {
            this.recommendEntityMap = recommendEntityMap;
        }

        public Integer apply(ItemDto input) {
            QihoItemRecommendEntity recommendEntity = this.recommendEntityMap.get(input.getId());
            return recommendEntity.getPayload();
        }
    }
}

