/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.bo;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.qiho.center.common.dao.QihoCategoryDAO;
import com.qiho.center.common.dao.QihoItemExtDAO;
import com.qiho.center.common.daoh.qiho.tag.BaiqiTagCategoryWeightMapper;
import com.qiho.center.common.daoh.qiho.tag.QihoItemTagMapper;
import com.qiho.center.common.daoh.qiho.tag.QihoTagMapper;
import com.qiho.center.common.daoh.qiho.tag.QihoTagTypeCategoryMapper;
import com.qiho.center.common.daoh.qihostatistics.data.QihoAdvertReportMapper;
import com.qiho.center.common.entity.BaseEntity;
import com.qiho.center.common.entity.item.QihoCategoryEntity;
import com.qiho.center.common.entity.item.QihoItemExtEntity;
import com.qiho.center.common.entityd.qiho.data.QihoAdvertReportSumEntity;
import com.qiho.center.common.entityd.qiho.tag.BaiqiTagCategoryWeightEntity;
import com.qiho.center.common.entityd.qiho.tag.QihoItemTagEntity;
import com.qiho.center.common.entityd.qiho.tag.QihoTagEntity;
import com.qiho.center.common.entityd.qiho.tag.QihoTagTypeCategoryEntity;
import com.qiho.center.common.util.SimilarityUtil;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class ItemSimilarityBo {
    @Resource
    private QihoAdvertReportMapper qihoAdvertReportMapper;
    @Resource
    private QihoItemTagMapper qihoItemTagMapper;
    @Resource
    private BaiqiTagCategoryWeightMapper baiqiTagCategoryWeightMapper;
    @Resource
    private QihoItemExtDAO qihoItemExtDAO;
    @Resource
    private QihoTagMapper qihoTagMapper;
    @Resource
    private QihoTagTypeCategoryMapper qihoTagTypeCategoryMapper;
    @Resource
    private QihoCategoryDAO qihoCategoryDAO;
    @Resource
    private RedisTemplate<String, Map<Long, Map<Long, Float>>> redisTemplate;

    public void doSimilarity() {
        this.baiqiTagCategoryWeightMapper.deleteAll();
        LocalDate curDateStart = LocalDate.now().minusWeeks(1L);
        ZoneId zoneId = ZoneId.systemDefault();
        ZonedDateTime zdt = curDateStart.atStartOfDay(zoneId);
        List sumEntityList = this.qihoAdvertReportMapper.findByCurDate(Date.from(zdt.toInstant()));
        List itemIdList = sumEntityList.stream().map(QihoAdvertReportSumEntity::getItemId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(itemIdList)) {
            return;
        }
        Map<Long, QihoAdvertReportSumEntity> itemIdToSumMap = sumEntityList.stream().collect(Collectors.toMap(QihoAdvertReportSumEntity::getItemId, a -> a));
        List itemTagEntityList = this.qihoItemTagMapper.findByItemIds(itemIdList);
        if (CollectionUtils.isEmpty((Collection)itemTagEntityList)) {
            return;
        }
        HashMap<Long, List<Long>> tagIdToItemIdsMap = new HashMap<Long, List<Long>>();
        HashMap<Long, List<Long>> itemIdToTagIdsMap = new HashMap<Long, List<Long>>();
        this.dealItemAndTagMap(itemTagEntityList, tagIdToItemIdsMap, itemIdToTagIdsMap);
        List itemExtEntityList = this.qihoItemExtDAO.queryAllExtParam(itemIdList);
        HashSet<Long> allSecondCategoryIdList = new HashSet<Long>();
        HashMap<Long, List<Long>> categoryIdToItemIdsMap = new HashMap<Long, List<Long>>();
        HashMap<Long, List<Long>> itemIdToCategoryIdsMap = new HashMap<Long, List<Long>>();
        this.dealItemAndCategory(itemExtEntityList, allSecondCategoryIdList, categoryIdToItemIdsMap, itemIdToCategoryIdsMap);
        Set tagIdList = itemTagEntityList.stream().map(QihoItemTagEntity::getTagId).collect(Collectors.toSet());
        List tagEntityList = this.qihoTagMapper.findIdAndTypeId(new ArrayList(tagIdList));
        Map<Long, Long> tagToTypeIdMap = tagEntityList.stream().collect(Collectors.toMap(BaseEntity::getId, QihoTagEntity::getTypeId));
        Set tagTypeIds = tagEntityList.stream().map(QihoTagEntity::getTypeId).collect(Collectors.toSet());
        List tagTypeCategoryEntityList = this.qihoTagTypeCategoryMapper.findByTypeIds(new ArrayList(tagTypeIds));
        Map<Long, List<Long>> tagTypeToCategoryIdsMap = this.dealTagTypeToCategoryIdsMap(tagTypeCategoryEntityList);
        Set categoryIds = tagTypeCategoryEntityList.stream().map(QihoTagTypeCategoryEntity::getCategoryId).collect(Collectors.toSet());
        List categoryEntityList = this.qihoCategoryDAO.findByPids(new ArrayList(categoryIds));
        Map<Long, List<Long>> firstCategoryIdToSeccendIdsMap = this.dealFirstCategoryIdToSeccendIdsMap(categoryEntityList);
        ArrayList<BaiqiTagCategoryWeightEntity> list = new ArrayList<BaiqiTagCategoryWeightEntity>();
        HashMap<String, BigDecimal> tagWeightMap = new HashMap<String, BigDecimal>();
        for (Long tagId : tagIdList) {
            Long tagTypeId = tagToTypeIdMap.get(tagId);
            List<Long> firstCategoryIds = tagTypeToCategoryIdsMap.get(tagTypeId);
            ArrayList<Long> secondCategoryIds = new ArrayList<Long>();
            this.deal(firstCategoryIds, firstCategoryIdToSeccendIdsMap, secondCategoryIds);
            Set finalSecondCategoryIds = secondCategoryIds.stream().filter(allSecondCategoryIdList::contains).collect(Collectors.toSet());
            List itemIdsByTagId = (List)tagIdToItemIdsMap.get(tagId);
            Set<Long> finalCategoryIds = this.doo(itemIdsByTagId, itemIdToCategoryIdsMap);
            if (!CollectionUtils.isNotEmpty(finalSecondCategoryIds)) continue;
            for (Long secondCategoryId : finalSecondCategoryIds) {
                List itemIds = (List)categoryIdToItemIdsMap.get(secondCategoryId);
                List<Long> finalItemIds = itemIdsByTagId.stream().filter(itemIds::contains).collect(Collectors.toList());
                List<Long> allTagIds = this.dealAllTagIds(itemIds, itemIdToTagIdsMap);
                this.dealWeight(finalItemIds, allTagIds, itemIdToSumMap, allSecondCategoryIdList, finalCategoryIds, list, secondCategoryId, tagId, tagWeightMap);
            }
        }
        if (CollectionUtils.isNotEmpty(list)) {
            this.baiqiTagCategoryWeightMapper.batchInsert(list);
            this.dealSimilarity(categoryIdToItemIdsMap, itemIdToTagIdsMap, tagWeightMap);
        }
    }

    private List<Long> dealAllTagIds(List<Long> itemIds, Map<Long, List<Long>> itemIdToTagIdsMap) {
        ArrayList<Long> allTagIds = new ArrayList<Long>();
        for (Long itemId : itemIds) {
            List<Long> tagIds = itemIdToTagIdsMap.get(itemId);
            if (!CollectionUtils.isNotEmpty(tagIds)) continue;
            allTagIds.addAll(tagIds);
        }
        return allTagIds;
    }

    private void dealWeight(List<Long> finalItemIds, List<Long> allTagIds, Map<Long, QihoAdvertReportSumEntity> itemIdToSumMap, Set<Long> allSecondCategoryIdList, Set<Long> finalCategoryIds, List<BaiqiTagCategoryWeightEntity> list, Long secondCategoryId, Long tagId, Map<String, BigDecimal> tagWeightMap) {
        if (CollectionUtils.isNotEmpty(finalItemIds) && CollectionUtils.isNotEmpty(allTagIds)) {
            long allIssueCouponsSum = 0L;
            long allOrderCountSum = 0L;
            for (Long itemId : finalItemIds) {
                QihoAdvertReportSumEntity entity = itemIdToSumMap.get(itemId);
                allIssueCouponsSum += entity.getIssueCouponsSum().longValue();
                allOrderCountSum += entity.getOrderCountSum().longValue();
            }
            BigDecimal tagWeight = allIssueCouponsSum == 0L ? new BigDecimal(0) : BigDecimal.valueOf(finalItemIds.size()).divide(BigDecimal.valueOf(allTagIds.size()), 10, 1).multiply(BigDecimal.valueOf(Math.log(BigDecimal.valueOf(allSecondCategoryIdList.size()).divide(BigDecimal.valueOf(finalCategoryIds.size()), 10, 1).doubleValue()))).divide(BigDecimal.valueOf(allIssueCouponsSum), 10, 1).multiply(BigDecimal.valueOf(allOrderCountSum)).setScale(10, 1).stripTrailingZeros();
            BaiqiTagCategoryWeightEntity entity = new BaiqiTagCategoryWeightEntity();
            entity.setCategoryId(secondCategoryId);
            entity.setTagId(tagId);
            entity.setWeight(tagWeight);
            list.add(entity);
            tagWeightMap.put(tagId + "_" + secondCategoryId, tagWeight);
        }
    }

    private void deal(List<Long> firstCategoryIds, Map<Long, List<Long>> firstCategoryIdToSeccendIdsMap, List<Long> secondCategoryIds) {
        for (Long firstCategoryId : firstCategoryIds) {
            List<Long> ids = firstCategoryIdToSeccendIdsMap.get(firstCategoryId);
            if (!CollectionUtils.isNotEmpty(ids)) continue;
            secondCategoryIds.addAll(ids);
        }
    }

    private Set<Long> doo(List<Long> itemIdsByTagId, Map<Long, List<Long>> itemIdToCategoryIdsMap) {
        HashSet<Long> finalCategoryIds = new HashSet<Long>();
        for (Long itemId : itemIdsByTagId) {
            List<Long> ids = itemIdToCategoryIdsMap.get(itemId);
            if (!CollectionUtils.isNotEmpty(ids)) continue;
            finalCategoryIds.addAll(ids);
        }
        return finalCategoryIds;
    }

    private void dealItemAndCategory(List<QihoItemExtEntity> itemExtEntityList, Set<Long> allSecondCategoryIdList, Map<Long, List<Long>> categoryIdToItemIdsMap, Map<Long, List<Long>> itemIdToCategoryIdsMap) {
        for (QihoItemExtEntity entity : itemExtEntityList) {
            Map extParam = (Map)JSON.parseObject((String)entity.getExtParam(), (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
            List categoryIds = (List)JSON.parseObject((String)((String)extParam.get("categoryIdList")), (TypeReference)new TypeReference<List<Long>>(){}, (Feature[])new Feature[0]);
            if (categoryIds.size() <= 1) continue;
            Long categoryId = (Long)categoryIds.get(1);
            allSecondCategoryIdList.add(categoryId);
            List<Long> itemIds = categoryIdToItemIdsMap.get(categoryId);
            if (CollectionUtils.isEmpty(itemIds)) {
                itemIds = new ArrayList<Long>();
                itemIds.add(entity.getItemId());
                categoryIdToItemIdsMap.put(categoryId, itemIds);
            } else {
                itemIds.add(entity.getItemId());
            }
            List<Long> secondCategoryIds = itemIdToCategoryIdsMap.get(entity.getItemId());
            if (CollectionUtils.isEmpty(secondCategoryIds)) {
                secondCategoryIds = new ArrayList<Long>();
                secondCategoryIds.add(categoryId);
                itemIdToCategoryIdsMap.put(entity.getItemId(), secondCategoryIds);
                continue;
            }
            secondCategoryIds.add(categoryId);
        }
    }

    private Map<Long, List<Long>> dealTagTypeToCategoryIdsMap(List<QihoTagTypeCategoryEntity> tagTypeCategoryEntityList) {
        HashMap<Long, List<Long>> tagTypeToCategoryIdsMap = new HashMap<Long, List<Long>>();
        for (QihoTagTypeCategoryEntity entity : tagTypeCategoryEntityList) {
            ArrayList<Long> firstCategoryIds = (ArrayList<Long>)tagTypeToCategoryIdsMap.get(entity.getTypeId());
            if (CollectionUtils.isEmpty((Collection)firstCategoryIds)) {
                firstCategoryIds = new ArrayList<Long>();
                firstCategoryIds.add(entity.getCategoryId());
                tagTypeToCategoryIdsMap.put(entity.getTypeId(), firstCategoryIds);
                continue;
            }
            firstCategoryIds.add(entity.getCategoryId());
        }
        return tagTypeToCategoryIdsMap;
    }

    private void dealItemAndTagMap(List<QihoItemTagEntity> itemTagEntityList, Map<Long, List<Long>> tagIdToItemIdsMap, Map<Long, List<Long>> itemIdToTagIdsMap) {
        for (QihoItemTagEntity entity : itemTagEntityList) {
            List<Long> itemIds = tagIdToItemIdsMap.get(entity.getTagId());
            if (CollectionUtils.isEmpty(itemIds)) {
                itemIds = new ArrayList<Long>();
                itemIds.add(entity.getItemId());
                tagIdToItemIdsMap.put(entity.getTagId(), itemIds);
            } else {
                itemIds.add(entity.getItemId());
            }
            List<Long> tagIds = itemIdToTagIdsMap.get(entity.getItemId());
            if (CollectionUtils.isEmpty(tagIds)) {
                tagIds = new ArrayList<Long>();
                tagIds.add(entity.getTagId());
                itemIdToTagIdsMap.put(entity.getItemId(), tagIds);
                continue;
            }
            tagIds.add(entity.getTagId());
        }
    }

    private Map<Long, List<Long>> dealFirstCategoryIdToSeccendIdsMap(List<QihoCategoryEntity> categoryEntityList) {
        HashMap<Long, List<Long>> firstCategoryIdToSeccendIdsMap = new HashMap<Long, List<Long>>();
        for (QihoCategoryEntity entity : categoryEntityList) {
            ArrayList<Long> secondCategoryIds = (ArrayList<Long>)firstCategoryIdToSeccendIdsMap.get(entity.getPid());
            if (CollectionUtils.isEmpty((Collection)secondCategoryIds)) {
                secondCategoryIds = new ArrayList<Long>();
                secondCategoryIds.add(entity.getId());
                firstCategoryIdToSeccendIdsMap.put(entity.getPid(), secondCategoryIds);
                continue;
            }
            secondCategoryIds.add(entity.getId());
        }
        return firstCategoryIdToSeccendIdsMap;
    }

    private void dealSimilarity(Map<Long, List<Long>> categoryIdToItemIdsMap, Map<Long, List<Long>> itemIdToTagIdsMap, Map<String, BigDecimal> tagWeightMap) {
        Set<Long> secondCategoryIds = categoryIdToItemIdsMap.keySet();
        HashMap<Long, Map<Long, Float>> similarityMap = new HashMap<Long, Map<Long, Float>>();
        for (Long secondCategoryId : secondCategoryIds) {
            List<Long> itemIds = categoryIdToItemIdsMap.get(secondCategoryId);
            if (itemIds.size() < 2) continue;
            Map<Long, Map<Long, BigDecimal>> map = this.dealItemAndTagAndWeight(itemIds, itemIdToTagIdsMap, tagWeightMap, secondCategoryId);
            SimilarityUtil util = new SimilarityUtil(map);
            int size = itemIds.size();
            for (int i = 0; i < size - 1; ++i) {
                Long itemId = itemIds.get(i);
                Map itemMap = (Map)similarityMap.get(itemId);
                for (int j = i + 1; j < size; ++j) {
                    Long anotherItemId = itemIds.get(j);
                    Float similarity = Float.valueOf(util.sim(itemId, anotherItemId).floatValue());
                    this.dealMap(itemMap, similarityMap, itemId, anotherItemId, similarity);
                    Map itemMap2 = (Map)similarityMap.get(anotherItemId);
                    this.dealMap(itemMap2, similarityMap, anotherItemId, itemId, similarity);
                }
            }
        }
        this.redisTemplate.opsForValue().set((Object)"item_similarity_key", similarityMap, 1L, TimeUnit.DAYS);
    }

    private void dealMap(Map<Long, Float> itemMap, Map<Long, Map<Long, Float>> similarityMap, Long itemId, Long anotherItemId, Float similarity) {
        if (MapUtils.isEmpty(itemMap)) {
            itemMap = new HashMap<Long, Float>();
            itemMap.put(anotherItemId, similarity);
            similarityMap.put(itemId, itemMap);
        } else {
            itemMap.put(anotherItemId, similarity);
        }
    }

    private Map<Long, Map<Long, BigDecimal>> dealItemAndTagAndWeight(List<Long> itemIds, Map<Long, List<Long>> itemIdToTagIdsMap, Map<String, BigDecimal> tagWeightMap, Long secondCategoryId) {
        HashMap<Long, Map<Long, BigDecimal>> map = new HashMap<Long, Map<Long, BigDecimal>>();
        ListIterator<Long> iterator = itemIds.listIterator();
        while (iterator.hasNext()) {
            Long itemId = (Long)iterator.next();
            List<Long> tagIds = itemIdToTagIdsMap.get(itemId);
            if (CollectionUtils.isEmpty(tagIds)) {
                iterator.remove();
                continue;
            }
            for (Long tagId : tagIds) {
                HashMap<Long, BigDecimal> itemToWeight = (HashMap<Long, BigDecimal>)map.get(tagId);
                BigDecimal weight = tagWeightMap.get(tagId + "_" + secondCategoryId);
                BigDecimal bigDecimal = weight = weight == null ? BigDecimal.valueOf(0L) : weight;
                if (MapUtils.isEmpty((Map)itemToWeight)) {
                    itemToWeight = new HashMap<Long, BigDecimal>();
                    itemToWeight.put(itemId, weight);
                    map.put(tagId, itemToWeight);
                    continue;
                }
                itemToWeight.put(itemId, weight);
            }
        }
        return map;
    }
}

