/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.bo;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.RateLimiter;
import com.qiho.center.api.dto.logistics.LogisticsOrderDto;
import com.qiho.center.api.dto.logistics.LogisticsProcessDto;
import com.qiho.center.api.enums.KuaiDi100LogisticsOrderStatusEnum;
import com.qiho.center.api.enums.KuaiDi100OrderStatusEnum;
import com.qiho.center.api.enums.logistics.LogisticsExpressPlatformEnum;
import com.qiho.center.biz.bo.domain.LogisticsOrderDo;
import com.qiho.center.biz.service.LogisticsOrderService;
import com.qiho.center.biz.service.logistics.Express100LogisticsService;
import com.qiho.center.biz.service.logistics.LogisticsService;
import com.qiho.center.biz.service.logistics.LogisticsSubscribeService;
import com.qiho.center.common.entityd.qiho.logistics.BaiqiLogisticsEntity;
import com.qiho.center.common.entityd.qiho.logistics.BaiqiLogisticsSubscribeEntity;
import com.qiho.center.common.entityd.qiho.logistics.Express100LogisticsEntity;
import com.qiho.center.common.params.kuaidi100.Result;
import com.qiho.center.common.params.kuaidi100.ResultItem;
import com.qiho.center.common.params.kuaidi100.TaskResponse;
import com.qiho.center.common.util.KuaiDi100Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class KuaiDi100Bo {
    private static final Logger LOGGER = LoggerFactory.getLogger(KuaiDi100Bo.class);
    @Resource
    private LogisticsOrderService logisticsOrderService;
    @Resource
    private Express100LogisticsService express100LogisticsService;
    @Resource
    private LogisticsService logisticsService;
    @Resource
    private LogisticsSubscribeService subscribeService;
    private static RateLimiter rateLimiter = RateLimiter.create((double)20.0, (long)1L, (TimeUnit)TimeUnit.SECONDS);

    public Boolean dealKuaiDi100Status(String com, String postId, String status, String condition) {
        LOGGER.info("\u5feb\u9012100 \u63a8\u9001\u4fe1\u606f\uff1a\u5feb\u9012\u516c\u53f8\u7f16\u7801\uff1a{}\uff0c \u5feb\u9012\u5355\u53f7: {} \uff0c\u5feb\u9012\u5355\u5f53\u524d\u72b6\u6001: {}, \u5feb\u9012\u5355\u660e\u7ec6\u72b6\u6001\u6807\u8bb0:{}", new Object[]{com, postId, status, condition});
        LogisticsOrderDto dto = new LogisticsOrderDto();
        KuaiDi100LogisticsOrderStatusEnum kuaiDi100LogisticsOrderStatusEnum = KuaiDi100LogisticsOrderStatusEnum.getByState((String)status);
        if (kuaiDi100LogisticsOrderStatusEnum != null) {
            dto.setLogisticsStatus(kuaiDi100LogisticsOrderStatusEnum.getDesc());
        } else {
            dto.setLogisticsStatus(status);
        }
        KuaiDi100OrderStatusEnum statusEnum = KuaiDi100OrderStatusEnum.getByKuaiDi100Status((String)status);
        if (statusEnum == null) {
            return true;
        }
        if (statusEnum == KuaiDi100OrderStatusEnum.UNDER_WAY && "JQ001".equals(condition)) {
            dto.setOrderStatus(KuaiDi100OrderStatusEnum.REJECTED.getStatus());
        } else {
            dto.setOrderStatus(statusEnum.getStatus());
        }
        dto.setPostId(postId);
        Express100LogisticsEntity express100LogisticsEntity = this.express100LogisticsService.findByCode(com);
        if (express100LogisticsEntity == null) {
            LOGGER.error("\u5feb\u9012100\u63a8\u9001\u7684\u5feb\u9012\u516c\u53f8\u4ee3\u7801\u8868\u4e2d\u4e0d\u5b58\u5728:", (Object)com);
            return false;
        }
        BaiqiLogisticsEntity baiqiLogisticsEntity = this.logisticsService.findById(express100LogisticsEntity.getBaiqiLogisticsId());
        if (baiqiLogisticsEntity == null) {
            LOGGER.error("\u5feb\u9012100\u63a8\u9001\u7684\u5feb\u9012\u516c\u53f8\u6240\u6620\u5c04\u7684\u767e\u5947\u7269\u6d41\u516c\u53f8\u4e0d\u5b58\u5728:", (Object)express100LogisticsEntity.getBaiqiLogisticsId());
            return false;
        }
        dto.setLogisticsCode(baiqiLogisticsEntity.getLogisticsCode());
        this.logisticsOrderService.update(dto);
        return true;
    }

    public void dealpostOrders(List<LogisticsOrderDo> list) {
        List groupList = Lists.partition(list, (int)20);
        Express100LogisticsEntity express100LogisticsEntity = null;
        for (List listFinal : groupList) {
            for (LogisticsOrderDo logisticsOrderDo : listFinal) {
                express100LogisticsEntity = this.express100LogisticsService.findByBaiqiLogisticsCode(logisticsOrderDo.getLogisticsCode());
                if (express100LogisticsEntity == null) {
                    LOGGER.error("\u5728\u5feb\u9012100\u7269\u6d41\u8868\u4e2d\u4e0d\u5b58\u5728\u767e\u5947\u5feb\u9012\u516c\u53f8\u4ee3\u7801:{}", (Object)logisticsOrderDo.getLogisticsCode());
                    continue;
                }
                BaiqiLogisticsSubscribeEntity subscribeEntity = new BaiqiLogisticsSubscribeEntity();
                subscribeEntity.setLogisticsCode(express100LogisticsEntity.getLogisticsCode());
                subscribeEntity.setExpressPlatform(LogisticsExpressPlatformEnum.HUNDRED.getName());
                subscribeEntity.setPostId(logisticsOrderDo.getPostId());
                this.saveOrder(subscribeEntity);
                rateLimiter.acquire();
                this.postOrder(subscribeEntity);
            }
        }
    }

    private void saveOrder(BaiqiLogisticsSubscribeEntity subscribeEntity) {
        int count = this.subscribeService.countLogisticsSubscribe(subscribeEntity.getPostId());
        if (count <= 0) {
            this.subscribeService.insertLogisticsSubscribe(subscribeEntity);
        }
    }

    private void postOrder(BaiqiLogisticsSubscribeEntity subscribeEntity) {
        TaskResponse response = KuaiDi100Util.postOrder((String)subscribeEntity.getLogisticsCode(), (String)subscribeEntity.getPostId());
        if (response != null && StringUtils.isNotBlank((CharSequence)response.getReturnCode())) {
            this.subscribeService.changeLogisticsSubscribe(subscribeEntity);
        }
    }

    public List<LogisticsProcessDto> queryWaybillTrace(String logisticsCode, String postId) {
        if (StringUtils.isBlank((CharSequence)postId)) {
            return Collections.emptyList();
        }
        Express100LogisticsEntity express100LogisticsEntity = this.express100LogisticsService.findByBaiqiLogisticsCode(logisticsCode);
        if (express100LogisticsEntity == null) {
            LOGGER.error("\u83b7\u53d6\u4e0d\u5230\u5feb\u9012100\u7269\u6d41\u516c\u53f8\u4fe1\u606f");
            return Collections.emptyList();
        }
        ArrayList resultList = null;
        try {
            Result result = KuaiDi100Util.queryWaybillTrace((String)express100LogisticsEntity.getLogisticsCode(), (String)postId);
            if (result != null && CollectionUtils.isNotEmpty((Collection)result.getData())) {
                ArrayList list = result.getData();
                resultList = Lists.newArrayListWithCapacity((int)list.size());
                for (ResultItem resultItem : list) {
                    LogisticsProcessDto logisticsProcessDto = new LogisticsProcessDto();
                    logisticsProcessDto.setWaybillNo(postId);
                    logisticsProcessDto.setUploadTime(resultItem.getFtime());
                    logisticsProcessDto.setProcessInfo(resultItem.getContext());
                    resultList.add(logisticsProcessDto);
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("\u5feb\u9012100\u8fd0\u5355\u8d70\u4ef6\u6d41\u7a0b\u5f02\u5e38\uff0c postId = " + postId, (Throwable)e);
        }
        return resultList;
    }
}

