/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.bo;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qiho.center.api.dto.media.MediaWarningDto;
import com.qiho.center.api.enums.ordertmp.OrderTmpStatusEnum;
import com.qiho.center.api.exception.QihoException;
import com.qiho.center.api.params.ordertmp.OrderTmpPageParam;
import com.qiho.center.common.dao.QihoChannelInfoDAO;
import com.qiho.center.common.dao.QihoConfigDAO;
import com.qiho.center.common.daoh.qiho.media.BaiqiMediaWarningMapper;
import com.qiho.center.common.daoh.qiho.ordertmp.BaiqiOrderTmpExtMapper;
import com.qiho.center.common.daoh.qiho.ordertmp.BaiqiOrderTmpMapper;
import com.qiho.center.common.daoh.qihostatistics.BaiqiTuiaAppStatisMapper;
import com.qiho.center.common.entity.QihoConfigEntity;
import com.qiho.center.common.entityd.qiho.media.BaiqiMediaWarningEntity;
import com.qiho.center.common.util.DingTalkUtil;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class MediaOrderBo {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaOrderBo.class);
    private static final BigDecimal DEAULT_THRESHOLD = new BigDecimal("0.1");
    private static final BigDecimal MIN_THRESHOLD = new BigDecimal("0.01");
    private static final BigDecimal MAX_THRESHOLD = new BigDecimal("1");
    private static final BigDecimal DEFAULT_ORDER_NUM_THRESHOLD = new BigDecimal("10");
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("#.##");
    @Value(value="${dingtalk.mediaorder.url}")
    private String dingTalkRobot;
    @Autowired
    private BaiqiOrderTmpMapper baiqiOrderTmpMapper;
    @Autowired
    private BaiqiOrderTmpExtMapper baiqiOrderTmpExtMapper;
    @Autowired
    private QihoChannelInfoDAO qihoChannelInfoDAO;
    @Autowired
    private QihoConfigDAO qihoConfigDAO;
    @Autowired
    private BaiqiTuiaAppStatisMapper baiqiTuiaAppStatisMapper;
    @Autowired
    private BaiqiMediaWarningMapper baiqiMediaWarningMapper;

    public void doTask() {
        Date startTime = new DateTime().minusHours(1).toDate();
        Date endTime = new Date();
        HashMap invalidAppIdMap = Maps.newHashMap();
        ArrayList invalidAppIdList = Lists.newArrayList();
        this.getInvalidAppId(invalidAppIdMap, invalidAppIdList, startTime, endTime);
        if (CollectionUtils.isEmpty((Collection)invalidAppIdList)) {
            return;
        }
        Map<Long, Integer> normalAppIdMap = this.getNormalAppId(invalidAppIdList, startTime, endTime);
        BigDecimal threshold = this.getWarningThreshold();
        List<MediaWarningDto> mediaWarningDtoList = this.getWarningAppId(threshold, invalidAppIdMap, normalAppIdMap, startTime, endTime);
        if (CollectionUtils.isEmpty(mediaWarningDtoList)) {
            return;
        }
        this.obtainAppName(mediaWarningDtoList);
        this.saveWarningData(mediaWarningDtoList);
        this.sendDingTalkMsg(mediaWarningDtoList);
    }

    private void getInvalidAppId(Map<Long, Integer> invalidAppIdMap, List<Long> invalidAppIdList, Date startTime, Date endTime) {
        OrderTmpPageParam orderTmpParam = new OrderTmpPageParam();
        orderTmpParam.setStartTime(startTime);
        orderTmpParam.setEndTime(endTime);
        orderTmpParam.setOrderStatus(Integer.valueOf(OrderTmpStatusEnum.INVALID.getNum()));
        List orderIds = this.baiqiOrderTmpMapper.findOrderIdsByParam(orderTmpParam);
        if (CollectionUtils.isEmpty((Collection)orderIds)) {
            return;
        }
        List orderTmpExtEntityList = this.baiqiOrderTmpExtMapper.findBatchByOrderIds(orderIds);
        orderTmpExtEntityList.stream().filter(e -> e.getAppId() != null).forEach(e -> {
            invalidAppIdList.add(e.getAppId());
            if (invalidAppIdMap.get(e.getAppId()) != null) {
                Integer num = (Integer)invalidAppIdMap.get(e.getAppId());
                invalidAppIdMap.put(e.getAppId(), num + 1);
            } else {
                invalidAppIdMap.put(e.getAppId(), 1);
            }
        });
    }

    private Map<Long, Integer> getNormalAppId(List<Long> appIdList, Date startTime, Date endTime) {
        HashMap normalAppIdMap = Maps.newHashMap();
        HashMap channelInfoParam = Maps.newHashMap();
        channelInfoParam.put("startTime", startTime);
        channelInfoParam.put("endTime", endTime);
        channelInfoParam.put("appIdList", appIdList);
        List channelInfoEntities = this.qihoChannelInfoDAO.findByAppIdList((Map)channelInfoParam);
        if (CollectionUtils.isEmpty((Collection)channelInfoEntities)) {
            return normalAppIdMap;
        }
        channelInfoEntities.forEach(e -> {
            if (normalAppIdMap.get(e.getAppId()) != null) {
                Integer num = (Integer)normalAppIdMap.get(e.getAppId());
                normalAppIdMap.put(e.getAppId(), num + 1);
            } else {
                normalAppIdMap.put(e.getAppId(), 1);
            }
        });
        return normalAppIdMap;
    }

    private BigDecimal getWarningThreshold() {
        QihoConfigEntity configEntity = this.qihoConfigDAO.findConfigByName("MEDIA_MONITOR_THRESHOLD");
        if (configEntity == null) {
            LOGGER.warn("\u67e5\u8be2\u4e0d\u5230\u5a92\u4f53\u544a\u8b66\u9608\u503c\uff0c\u8fd4\u56de\u9ed8\u8ba4\u9608\u503c");
            return DEAULT_THRESHOLD;
        }
        String configValue = configEntity.getConfigValue();
        if (StringUtils.isBlank((CharSequence)configValue)) {
            LOGGER.error("\u914d\u7f6e\u5a92\u4f53\u544a\u8b66\u9608\u503c\u4e3a\u7a7a");
            return DEAULT_THRESHOLD;
        }
        try {
            BigDecimal warningThreshold = new BigDecimal(configValue);
            if (warningThreshold.compareTo(MIN_THRESHOLD) < 0 || warningThreshold.compareTo(MAX_THRESHOLD) > 0) {
                throw new QihoException("\u9608\u503c\u914d\u7f6e\u9519\u8bef");
            }
            return warningThreshold;
        }
        catch (Exception e) {
            LOGGER.error("\u89e3\u6790\u5a92\u4f53\u544a\u8b66\u9608\u503c\u9519\u8bef\uff0c\u8fd4\u56de\u9ed8\u8ba4\u9608\u503c\uff0c\u914d\u7f6e\u7684value\u662f\uff1a{}", (Object)configValue, (Object)e);
            return DEAULT_THRESHOLD;
        }
    }

    private List<MediaWarningDto> getWarningAppId(BigDecimal threshold, Map<Long, Integer> invalidAppIdMap, Map<Long, Integer> normalAppIdMap, Date startTime, Date endTime) {
        BigDecimal orderNumThreshold = this.getOrderNumThreshold();
        ArrayList warningDtoList = Lists.newArrayList();
        invalidAppIdMap.forEach((key, value) -> {
            BigDecimal normalNum;
            BigDecimal invalidNum;
            Integer normalOrderNum = (Integer)normalAppIdMap.get(key);
            if (normalOrderNum == null) {
                normalOrderNum = 0;
            }
            if ((invalidNum = new BigDecimal((int)value)).add(normalNum = new BigDecimal(normalOrderNum)).compareTo(orderNumThreshold) < 0) {
                return;
            }
            BigDecimal invalidRate = invalidNum.divide(invalidNum.add(normalNum), 4, 4);
            if (invalidRate.compareTo(threshold) >= 0) {
                MediaWarningDto mediaWarningDto = new MediaWarningDto();
                mediaWarningDto.setAppId(key);
                mediaWarningDto.setInvalidOrderNum(value);
                mediaWarningDto.setThreshold(threshold);
                mediaWarningDto.setStartTime(startTime);
                mediaWarningDto.setEndTime(endTime);
                mediaWarningDto.setNormalOrderNum(normalOrderNum);
                mediaWarningDto.setInvalidRate(invalidRate);
                warningDtoList.add(mediaWarningDto);
            }
        });
        return warningDtoList;
    }

    private BigDecimal getOrderNumThreshold() {
        try {
            QihoConfigEntity configEntity = this.qihoConfigDAO.findConfigByName("MEDIA_ORDER_NUM_MONITOR_THRESHOLD");
            if (configEntity == null) {
                LOGGER.warn("\u67e5\u8be2\u4e0d\u5230\u5a92\u4f53\u8ba2\u5355\u6570\u91cf\u544a\u8b66\u9608\u503c\uff0c\u8fd4\u56de\u9ed8\u8ba4\u9608\u503c");
                return DEFAULT_ORDER_NUM_THRESHOLD;
            }
            String configValue = configEntity.getConfigValue();
            if (!StringUtils.isNumeric((CharSequence)configValue)) {
                throw new QihoException("\u5a92\u4f53\u8ba2\u5355\u6570\u91cf\u544a\u8b66\u9608\u503c\u914d\u7f6e\u9519\u8bef\uff0c \u5f53\u524d\u6570\u636e\u662f" + configValue);
            }
            return new BigDecimal(configValue);
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u8ba2\u5355\u6570\u91cf\u544a\u8b66\u9608\u503c\u5f02\u5e38 ", (Throwable)e);
            return DEFAULT_ORDER_NUM_THRESHOLD;
        }
    }

    private void obtainAppName(List<MediaWarningDto> mediaWarningDtoList) {
        List appIdList = mediaWarningDtoList.stream().map(MediaWarningDto::getAppId).collect(Collectors.toList());
        List tuiaAppEntityList = this.baiqiTuiaAppStatisMapper.listMediaByAppIds(appIdList);
        HashMap appNameMap = Maps.newHashMap();
        tuiaAppEntityList.forEach(e -> appNameMap.put(e.getAppId(), e.getAppName()));
        mediaWarningDtoList.forEach(e -> {
            String appName = (String)appNameMap.get(e.getAppId());
            if (StringUtils.isBlank((CharSequence)appName)) {
                e.setAppName("");
            } else {
                e.setAppName(appName);
            }
        });
    }

    private void saveWarningData(List<MediaWarningDto> mediaWarningDtoList) {
        List mediaWarningEntities = mediaWarningDtoList.stream().map(e -> {
            BaiqiMediaWarningEntity mediaWarningEntity = (BaiqiMediaWarningEntity)BeanUtils.copy((Object)e, BaiqiMediaWarningEntity.class);
            mediaWarningEntity.setThreshold(Integer.valueOf(e.getThreshold().multiply(new BigDecimal("10000")).intValue()));
            mediaWarningEntity.setInvalidRate(Integer.valueOf(e.getInvalidRate().multiply(new BigDecimal("10000")).intValue()));
            return mediaWarningEntity;
        }).collect(Collectors.toList());
        this.baiqiMediaWarningMapper.insertBatch(mediaWarningEntities);
    }

    private void sendDingTalkMsg(List<MediaWarningDto> mediaWarningDtoList) {
        StringBuilder msg = new StringBuilder("\u5a92\u4f53\u9632\u4f5c\u5f0a\u76d1\u63a7\u544a\u8b66\uff1a\n");
        for (MediaWarningDto mediaWarning : mediaWarningDtoList) {
            msg.append("\u5a92\u4f53ID\uff1a").append(mediaWarning.getAppId()).append("\uff0c\u5a92\u4f53\u540d\u79f0\uff1a").append(mediaWarning.getAppName()).append("\uff0c\u65e0\u6548\u8ba2\u5355\u6570\uff1a").append(mediaWarning.getInvalidOrderNum()).append("\uff0c\u6709\u6548\u8ba2\u5355\u6570\uff1a").append(mediaWarning.getNormalOrderNum()).append("\uff0c\u65e0\u6548\u8ba2\u5355\u5360\u6bd4\u8fbe").append(this.convertRateToPercent(mediaWarning.getInvalidRate())).append("\n");
        }
        msg.append("\u8bf7\u53ca\u65f6\u5173\u6ce8");
        DingTalkUtil.sendTextMessageWith((String)msg.toString(), (String)this.dingTalkRobot, (boolean)true);
    }

    private String convertRateToPercent(BigDecimal invalidRate) {
        BigDecimal b = invalidRate.multiply(new BigDecimal("100"));
        return DECIMAL_FORMAT.format(b) + "%";
    }
}

