/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.bo;

import com.qiho.center.biz.service.finance.FinanceService;
import com.qiho.center.biz.service.impl.finance.bean.CashRebateAmountBean;
import com.qiho.center.common.daoh.qiho.finance.BaiqiFinanceDetailMapper;
import com.qiho.center.common.entityd.qiho.finance.BaiqiFinanceDetailEntity;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Component
public class MerchantAdvertBO {
    private static final Logger LOGGER = LoggerFactory.getLogger(MerchantAdvertBO.class);
    @Resource
    private BaiqiFinanceDetailMapper financeDetailMapper;
    @Resource
    private FinanceService financeService;

    @Transactional(rollbackFor={Exception.class}, value="QIHO")
    public void saveDetailAndReduceAmount(Long financeId, BaiqiFinanceDetailEntity detailEntity, CashRebateAmountBean amountBean) {
        if (amountBean != null) {
            Long id = detailEntity.getId();
            try {
                if (id == null) {
                    this.financeDetailMapper.insert(detailEntity);
                } else {
                    this.financeDetailMapper.update(detailEntity);
                }
                this.financeService.updateFinanceAmountById(financeId, amountBean);
            }
            catch (Exception e) {
                LOGGER.error("saveDetailAndReduceAmount failed:", (Throwable)e);
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            }
        }
    }
}

