/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.bo;

import cn.com.duiba.wolf.utils.DateUtils;
import com.qiho.center.api.dto.ordertmp.OrderTmpDetailDto;
import com.qiho.center.api.enums.SmsTypeEnum;
import com.qiho.center.api.enums.ordersms.OrderSmsReceiveStatus;
import com.qiho.center.api.enums.ordersms.SmsMobileStatusEnum;
import com.qiho.center.api.enums.ordertmp.OrderTmpStatusEnum;
import com.qiho.center.biz.event.OrderTmpToFormalEvent;
import com.qiho.center.biz.service.ordertmp.OrderTmpService;
import com.qiho.center.common.daoh.qiho.ordertmp.BaiqiOrderSmsMapper;
import com.qiho.center.common.entityd.qiho.ordertmp.BaiqiOrderSmsEntity;
import com.qiho.center.common.params.OrderSmsParam;
import com.qiho.center.common.support.BizEventBus;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OrderSmsTimeOutBo {
    private static final Logger LOGGER = LoggerFactory.getLogger(OrderSmsTimeOutBo.class);
    @Autowired
    private BaiqiOrderSmsMapper baiqiOrderSmsMapper;
    @Autowired
    private OrderTmpService orderTmpService;
    @Autowired
    private BizEventBus eventBus;

    public void doJob() {
        List<BaiqiOrderSmsEntity> orderSmsEntities = this.getProcessData();
        if (CollectionUtils.isEmpty(orderSmsEntities)) {
            return;
        }
        for (BaiqiOrderSmsEntity baiqiOrderSmsEntity : orderSmsEntities) {
            try {
                String orderId = baiqiOrderSmsEntity.getOrderId();
                OrderTmpDetailDto orderTmpDetailDto = this.orderTmpService.findByOrderId(orderId);
                if (null == orderTmpDetailDto || orderTmpDetailDto.getOrderStatus().intValue() != OrderTmpStatusEnum.TO_FILTER.getNum()) continue;
                baiqiOrderSmsEntity.setReceiveStatus(Integer.valueOf(OrderSmsReceiveStatus.PROCESSES.getNum()));
                baiqiOrderSmsEntity.setMobileStatus(Integer.valueOf(SmsMobileStatusEnum.TIME_OUT.getNum()));
                this.baiqiOrderSmsMapper.updateMobileStatus(baiqiOrderSmsEntity);
                boolean bizCheckResult = this.orderTmpService.bizValidate(orderTmpDetailDto);
                if (!bizCheckResult) continue;
                OrderTmpToFormalEvent toFormalEvent = new OrderTmpToFormalEvent();
                toFormalEvent.setOrderId(orderId);
                this.eventBus.post((Object)toFormalEvent);
            }
            catch (Exception e) {
                LOGGER.warn("\u4e34\u65f6\u8ba2\u5355\u8d85\u65f6\u4efb\u52a1\u6267\u884c\u5f02\u5e38\uff0corderId:{},", (Object)baiqiOrderSmsEntity.getOrderId(), (Object)e);
            }
        }
    }

    private List<BaiqiOrderSmsEntity> getProcessData() {
        OrderSmsParam param = new OrderSmsParam();
        param.setReceiveStatus(Integer.valueOf(OrderSmsReceiveStatus.UNPROCESSES.getNum()));
        param.setSmsType(Integer.valueOf(SmsTypeEnum.CHUANG_LAN.getNum()));
        Date date = new Date();
        Date endTime = DateUtils.minutesAddOrSub((Date)date, (int)-2);
        Date startTime = DateUtils.minutesAddOrSub((Date)date, (int)-10);
        param.setEndTime(endTime);
        param.setStartTime(startTime);
        return this.baiqiOrderSmsMapper.findByParam(param);
    }
}

