/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.bo;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.OrderSnapshotDto;
import com.qiho.center.api.dto.order.PushOrderThirdPartyFailDto;
import com.qiho.center.biz.model.SsjxAddressBean;
import com.qiho.center.biz.service.order.OrderSnapshotService;
import com.qiho.center.biz.service.order.QihoOrderPushThirdPartyFailService;
import com.qiho.center.biz.util.QihoStringUtil;
import com.qiho.center.common.util.BigDecimalUtil;
import com.qiho.center.common.util.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class QihoOrderPushThirdPartyFailBo {
    @Value(value="${qiho.order.ssjx.merchantid}")
    private String ssjxMerchartId;
    @Resource
    private OrderSnapshotService orderSnapshotService;
    @Resource
    private QihoOrderPushThirdPartyFailService orderPushThirdPartyFailService;
    private static final List<Long> SSJX_WATCH_GIFT_ITEM_IDS = Lists.newArrayList((Object[])new Long[]{605L, 606L, 825L});

    public List<PushOrderThirdPartyFailDto> findAllByDate(Date startTime, Date endTime, Long merchantId) {
        ArrayList<Long> merchantids = new ArrayList<Long>();
        if (merchantId == null) {
            merchantids = StringUtil.stringToListOrderByIds((String)this.ssjxMerchartId);
        } else {
            merchantids.add(merchantId);
        }
        List<String> orderIdList = this.orderPushThirdPartyFailService.findAllByDate(startTime, endTime, merchantids);
        if (CollectionUtils.isEmpty(orderIdList)) {
            return Collections.emptyList();
        }
        List<OrderSnapshotDto> orderSnapshotDtos = this.orderSnapshotService.queryOrderByOrderIds(orderIdList);
        return this.convertToFailDto(orderSnapshotDtos);
    }

    private List<PushOrderThirdPartyFailDto> convertToFailDto(List<OrderSnapshotDto> orderSnapshotDtos) {
        ArrayList<PushOrderThirdPartyFailDto> failDtos = new ArrayList<PushOrderThirdPartyFailDto>();
        for (OrderSnapshotDto snapDto : orderSnapshotDtos) {
            String skuName = snapDto.getSkuName() == null ? "" : snapDto.getSkuName();
            String goodsSkuName = snapDto.getItemName() + skuName;
            PushOrderThirdPartyFailDto failDto = new PushOrderThirdPartyFailDto();
            failDto.setGoodstype(snapDto.getItemName());
            String goods0 = goodsSkuName + ",,," + snapDto.getQuantity() + "|";
            String goodsName = goodsSkuName + "*" + snapDto.getQuantity();
            if (SSJX_WATCH_GIFT_ITEM_IDS.contains(snapDto.getItemId())) {
                failDto.setGoodsName(goodsName + "\uff0c\u5145\u503c\u5361100\u5143*1");
                failDto.setGoods0(goods0 + "\u5145\u503c\u5361100\u5143,,,1|");
                failDto.setGoodstxm(snapDto.getSkuNo() + "*" + snapDto.getQuantity() + ",1001159990002*1");
            } else {
                failDto.setGoods0(goods0);
                failDto.setGoodsName(goodsName);
                failDto.setGoodstxm(snapDto.getSkuNo() + "*" + snapDto.getQuantity());
            }
            failDto.setGoodsPrice(BigDecimalUtil.integerToMove2PointLeft((Integer)snapDto.getOrderAmt()).stripTrailingZeros().toPlainString());
            failDto.setName(snapDto.getConsumerName());
            failDto.setTel(snapDto.getMobile());
            SsjxAddressBean addressBean = QihoStringUtil.analyzeSendTime(snapDto.getSendTime());
            if (addressBean != null) {
                failDto.setSendTime(addressBean.getSendTime());
                failDto.setProvince3(addressBean.getProvince3());
                failDto.setCity3(addressBean.getCity3());
                failDto.setArea3(addressBean.getArea3());
                failDto.setTownship3(addressBean.getTownship3());
            }
            failDto.setDetailedAddr(snapDto.getAddress() == null ? "" : snapDto.getAddress());
            String addrText = Joiner.on((String)"_").join(QihoStringUtil.excludeNullString(snapDto.getProvince(), snapDto.getCity(), snapDto.getDistrict(), snapDto.getAddress()));
            failDto.setDetailedAddrText(addrText);
            failDto.setMessage(snapDto.getMessage());
            failDto.setIp(snapDto.getIp());
            failDto.setCreateTime(snapDto.getGmtCreate());
            failDto.setOrderId(snapDto.getOrderId());
            failDto.setSid(snapDto.getSid());
            failDtos.add(failDto);
        }
        return failDtos;
    }
}

