/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.bo;

import cn.com.duiba.wolf.utils.DateUtils;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.base.Joiner;
import com.qiho.center.api.dto.OrderSnapshotDto;
import com.qiho.center.biz.model.OrderSyncParamBean;
import com.qiho.center.biz.model.SsjxAddressBean;
import com.qiho.center.biz.model.SsjxPushOrderBean;
import com.qiho.center.biz.service.order.QihoOrderPushThirdPartyFailService;
import com.qiho.center.biz.util.QihoStringUtil;
import com.qiho.center.common.constant.DomainConstantUtil;
import com.qiho.center.common.constant.Environment;
import com.qiho.center.common.entityd.qiho.order.QihoOrderPushThirdPartyFailEntity;
import com.qiho.center.common.util.BigDecimalUtil;
import com.qiho.center.common.util.HttpClientUtil;
import java.util.Date;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SsjxPushOrderBo {
    private static final Logger LOGGER = LoggerFactory.getLogger(SsjxPushOrderBo.class);
    @Resource
    private QihoOrderPushThirdPartyFailService qihoOrderPushThirdPartyFailService;

    public void createOrderSnapshotListener(OrderSnapshotDto entity, String smsRetCode) {
        try {
            SsjxPushOrderBean bean = this.orderSnapToBean(entity);
            bean.setSmsCode(smsRetCode);
            bean.setSmsSendTime(System.currentTimeMillis() / 1000L);
            if (Environment.isDaily() || Environment.isPrepub()) {
                LOGGER.info("\u6d4b\u8bd5\u73af\u5883\u6253\u5370\u77ed\u4fe1\u72b6\u6001\u548c\u63a8\u9001\u76db\u4e16\u5609\u7965\u8ba2\u5355\u6570\u636e\u3002orderId: {}, smsCode:{}, param:{}", new Object[]{entity.getOrderId(), smsRetCode, bean});
            }
            OrderSyncParamBean paramBean = new OrderSyncParamBean(entity.getOrderId(), entity.getMerchantId());
            this.sendOrderInfo(bean, paramBean, smsRetCode);
        }
        catch (Exception e) {
            LOGGER.error("\u8ba2\u5355\u540c\u6b65\u5931\u8d25", (Throwable)e);
            this.recodeSyncOrderFail(new OrderSyncParamBean(entity.getOrderId(), entity.getMerchantId()), "\u8ba2\u5355\u540c\u6b65\u5931\u8d25", smsRetCode);
        }
    }

    private void sendOrderInfo(SsjxPushOrderBean orderBean, OrderSyncParamBean paramBean, String smsRetCode) {
        String orderInfoJson = JSONObject.toJSONString((Object)orderBean);
        Map params = (Map)JSONObject.parseObject((String)orderInfoJson, (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
        String orderId = paramBean.getOrderId();
        String resp = HttpClientUtil.sendPostByIgnoreCookies((String)DomainConstantUtil.getSsjxOrderSyncUrl(), (Map)params);
        if (StringUtils.isBlank((CharSequence)resp)) {
            String failMsg = "\u8bf7\u6c42\u5931\u8d25";
            LOGGER.warn("\u53d1\u9001\u76db\u4e16\u5609\u7965\u8ba2\u5355\u540c\u6b65\u540c\u6b65\u5931\u8d25, url={}, orderId={},resp={}, param={}", new Object[]{DomainConstantUtil.getSsjxOrderSyncUrl(), orderId, failMsg, params});
            this.recodeSyncOrderFail(paramBean, failMsg, smsRetCode);
            return;
        }
        JSONObject jsonResp = JSONObject.parseObject((String)resp);
        if (jsonResp.getInteger("code") == 200) {
            return;
        }
        String failMsg = jsonResp.toJSONString();
        LOGGER.info("\u53d1\u9001\u76db\u4e16\u5609\u7965\u8ba2\u5355\u540c\u6b65\u540c\u6b65\u5931\u8d25, url={},orderId={},code={},resp={}, param={}", new Object[]{DomainConstantUtil.getSsjxOrderSyncUrl(), orderId, jsonResp.getInteger("code"), failMsg, params});
        this.recodeSyncOrderFail(paramBean, failMsg, smsRetCode);
    }

    private void recodeSyncOrderFail(OrderSyncParamBean paramBean, String failMsg, String smsRetCode) {
        QihoOrderPushThirdPartyFailEntity entity = new QihoOrderPushThirdPartyFailEntity();
        entity.setOrderId(paramBean.getOrderId());
        entity.setMerchantId(paramBean.getMerchantId());
        entity.setSmsRetCode(smsRetCode);
        entity.setRemark(failMsg);
        this.qihoOrderPushThirdPartyFailService.insert(entity);
    }

    private SsjxPushOrderBean orderSnapToBean(OrderSnapshotDto snapDto) {
        SsjxPushOrderBean orderBean = new SsjxPushOrderBean();
        String skuName = snapDto.getSkuName() == null ? "" : snapDto.getSkuName();
        String goodsSkuName = snapDto.getItemName() + skuName;
        orderBean.setGoodstype(snapDto.getItemName());
        String goods0 = goodsSkuName + ",,," + snapDto.getQuantity() + "|";
        String goodsName = goodsSkuName + "*" + snapDto.getQuantity();
        orderBean.setGoods0(goods0);
        orderBean.setGoodsName(goodsName);
        orderBean.setGoodstxm(snapDto.getSkuNo() + "*" + snapDto.getQuantity());
        orderBean.setGoodsPrice(BigDecimalUtil.integerToMove2PointLeft((Integer)snapDto.getOrderAmt()).stripTrailingZeros().toPlainString());
        orderBean.setName(snapDto.getConsumerName());
        orderBean.setTel(snapDto.getMobile());
        SsjxAddressBean addressBean = QihoStringUtil.analyzeSendTime(snapDto.getSendTime());
        if (addressBean != null) {
            orderBean.setSendTime(addressBean.getSendTime());
            orderBean.setProvince3(addressBean.getProvince3());
            orderBean.setCity3(addressBean.getCity3());
            orderBean.setArea3(addressBean.getArea3());
            orderBean.setTownship3(addressBean.getTownship3());
        }
        orderBean.setDetailedAddr(snapDto.getAddress());
        String addrText = Joiner.on((String)"_").join(QihoStringUtil.excludeNullString(snapDto.getProvince(), snapDto.getCity(), snapDto.getDistrict(), snapDto.getAddress()));
        orderBean.setDetailedAddrText(addrText);
        orderBean.setMessage(snapDto.getMessage() == null ? "" : snapDto.getMessage());
        orderBean.setIp(snapDto.getIp());
        orderBean.setCreateTime(DateUtils.getSecondStr((Date)snapDto.getGmtCreate()));
        orderBean.setSid(snapDto.getSid());
        orderBean.setBqorderid(snapDto.getOrderId());
        return orderBean;
    }
}

