/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.bo;

import cn.com.duiba.wolf.utils.DateUtils;
import com.qiho.center.api.enums.DealTypeEnum;
import com.qiho.center.api.enums.blacklist.BaiqiBlackListTypeEnum;
import com.qiho.center.api.enums.blacklist.BlackListUseTypeEnum;
import com.qiho.center.api.enums.blacklist.SourceTypeEnum;
import com.qiho.center.common.daoh.qiho.blacklist.BaiqiBlackListMapper;
import com.qiho.center.common.daoh.qihostatistics.blacklist.BaiqiBlackListTmpMapper;
import com.qiho.center.common.entity.BaseEntity;
import com.qiho.center.common.entityd.qiho.blacklist.BaiqiBlackListEntity;
import com.qiho.center.common.entityd.qihostatistics.SimpleBlackListTmpEntity;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SyncBlackListBo {
    @Autowired
    private BaiqiBlackListTmpMapper baiqiBlackListTmpMapper;
    @Autowired
    private BaiqiBlackListMapper baiqiBlackListMapper;

    public void executeTask() {
        this.clearStrategyBlackList();
        Date endTime = new Date();
        Date startTime = DateUtils.hoursAddOrSub((Date)endTime, (int)-6);
        List simpleBKList = this.baiqiBlackListTmpMapper.listAllGroupByMerchantId(startTime, endTime);
        if (CollectionUtils.isEmpty((Collection)simpleBKList)) {
            return;
        }
        for (SimpleBlackListTmpEntity simpleBlackList : simpleBKList) {
            List existValue = this.baiqiBlackListMapper.findSimpleValueByMerchantid(simpleBlackList.getMerchantId());
            List tmpValue = this.baiqiBlackListTmpMapper.listValueByMerchantId(simpleBlackList.getMerchantId(), startTime, endTime);
            tmpValue.removeAll(existValue);
            if (!CollectionUtils.isNotEmpty((Collection)tmpValue)) continue;
            this.baiqiBlackListMapper.insertBatch(this.buildInsertStrategyParam(simpleBlackList.getMerchantId(), tmpValue));
        }
    }

    private void clearStrategyBlackList() {
        List blackListEntities = this.baiqiBlackListMapper.listAllStrategyBlackList();
        if (CollectionUtils.isEmpty((Collection)blackListEntities)) {
            return;
        }
        List idList = blackListEntities.stream().map(BaseEntity::getId).collect(Collectors.toList());
        this.baiqiBlackListMapper.batchDeleteByIds(idList, "\u7b56\u7565\u5220\u9664");
    }

    private List<BaiqiBlackListEntity> buildInsertStrategyParam(Long merchantId, List<String> valueList) {
        return valueList.stream().map(e -> {
            BaiqiBlackListEntity blackList = new BaiqiBlackListEntity();
            blackList.setBkValue(e);
            blackList.setMerchantId(merchantId);
            blackList.setBkType(Integer.valueOf(BaiqiBlackListTypeEnum.PHONE.getNum()));
            blackList.setSourceType(Integer.valueOf(SourceTypeEnum.STRATEGY.getNum()));
            blackList.setDealType(Integer.valueOf(DealTypeEnum.FORBID_SUBMIT.getNum()));
            blackList.setOperator("\u7b56\u7565\u6dfb\u52a0");
            blackList.setUseType(Integer.valueOf(merchantId > 0L ? BlackListUseTypeEnum.PART.getNum() : BlackListUseTypeEnum.ALL.getNum()));
            return blackList;
        }).collect(Collectors.toList());
    }
}

