/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.engine.action;

import cn.com.duiba.wolf.utils.DateUtils;
import com.qiho.center.api.dto.OrderSnapshotDto;
import com.qiho.center.api.dto.StrategyRuleDto;
import com.qiho.center.api.dto.resultbase.ResultBase;
import com.qiho.center.api.enums.ShotOrder.ShotOrderRuleEnum;
import com.qiho.center.biz.engine.action.ShotOrderAbstractAction;
import com.qiho.center.common.dao.QihoItemMerchantDAO;
import com.qiho.center.common.dao.QihoOrderSnapshotDAO;
import com.qiho.center.common.entity.merchant.QihoItemMerchantEntity;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;

public class CountPhoneMerchantAction
extends ShotOrderAbstractAction {
    @Autowired
    private QihoOrderSnapshotDAO qihoOrderSnapshotDAO;
    @Autowired
    private QihoItemMerchantDAO qihoItemMerchantDAO;

    public ResultBase<Boolean> valuteCostomByQuery(OrderSnapshotDto orderSnapshotDto, StrategyRuleDto strategyRuleDto) {
        Long merchantId = orderSnapshotDto.getMerchantId();
        if (null == merchantId || merchantId < 0L) {
            QihoItemMerchantEntity itemMerchantEntity = this.qihoItemMerchantDAO.findByItemId(orderSnapshotDto.getItemId());
            if (null == itemMerchantEntity) {
                ResultBase.errorReturn((String)"\u83b7\u53d6\u4e0d\u5230\u5546\u5bb6\u4fe1\u606f");
            }
            merchantId = itemMerchantEntity.getMerchantId();
        }
        Date startTime = DateUtils.daysAddOrSub((Date)new Date(), (int)-1);
        Integer count = this.qihoOrderSnapshotDAO.countByMobileAndMerchantId(orderSnapshotDto.getMobile(), merchantId, startTime);
        return ShotOrderRuleEnum.fromVal((String)strategyRuleDto.getRuleName()).valuteOrderByQuery(strategyRuleDto.getThreshold(), (Object)count);
    }
}

