/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.engine.action;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qiho.center.api.dto.OrderSnapshotDto;
import com.qiho.center.api.dto.StrategyRuleDto;
import com.qiho.center.api.dto.resultbase.ResultBase;
import com.qiho.center.api.enums.ShotOrder.ShotOrderRuleEnum;
import com.qiho.center.biz.engine.action.ShotOrderAbstractAction;
import com.qiho.center.common.util.HttpClientUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvalidAddressAction
extends ShotOrderAbstractAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(InvalidAddressAction.class);

    public ResultBase<Boolean> valuteCostomByQuery(OrderSnapshotDto orderSnapshotDto, StrategyRuleDto strategyRuleDto) {
        String address = StringUtils.deleteWhitespace((String)orderSnapshotDto.getAddress());
        String city = this.filterCity(orderSnapshotDto.getProvince(), orderSnapshotDto.getCity());
        int cityCount = this.findCityCount(address, city);
        return ShotOrderRuleEnum.fromVal((String)strategyRuleDto.getRuleName()).valuteOrderByQuery(null, (Object)cityCount);
    }

    private String filterCity(String province, String city) {
        ArrayList filterCites = Lists.newArrayList((Object[])new String[]{"\u5317\u4eac\u5e02", "\u4e0a\u6d77\u5e02", "\u5929\u6d25\u5e02", "\u91cd\u5e86\u5e02"});
        if (filterCites.contains(province)) {
            return province;
        }
        return city;
    }

    private int findCityCount(String address, String city) {
        String path = this.getRequestPath(address, city);
        String result = HttpClientUtil.sendGet((String)path);
        if (StringUtils.isBlank((CharSequence)result)) {
            return 0;
        }
        JSONObject jsonObject = JSON.parseObject((String)result);
        Object count = jsonObject.get((Object)"count");
        if (count == null) {
            LOGGER.warn("\u67e5\u8be2\u9ad8\u5fb7\u5730\u7406\u9006\u7f16\u7801\u9519\u8bef:{}", (Object)result);
            return 0;
        }
        return Integer.valueOf(count.toString());
    }

    private String getRequestPath(String address, String city) {
        String encodeAddress;
        TreeMap paramMap = Maps.newTreeMap();
        try {
            encodeAddress = URLEncoder.encode(address, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("\u5730\u5740\u6709\u6548\u6027\u68c0\u9a8c\u65f6\uff0c\u5730\u5740\u7f16\u7801\u9519\u8bef\uff1a{}", (Object)address, (Object)e);
            encodeAddress = address;
        }
        paramMap.put("address", encodeAddress);
        paramMap.put("output", "JSON");
        paramMap.put("key", "7530a3262d11105e3d18d5122bb703bb");
        paramMap.put("city", city);
        StringBuilder sb = new StringBuilder("http://restapi.amap.com/v3/geocode/geo?");
        paramMap.forEach((k, v) -> sb.append((String)k).append("=").append((String)v).append("&"));
        return StringUtils.removeEnd((String)sb.toString(), (String)"&");
    }
}

