/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.engine.action;

import com.qiho.center.api.dto.OrderSnapshotDto;
import com.qiho.center.api.dto.StrategyRuleDto;
import com.qiho.center.api.dto.resultbase.ResultBase;
import com.qiho.center.api.enums.ShotOrder.ShotOrderRuleEnum;
import com.qiho.center.api.enums.bean.LocationCheckBean;
import com.qiho.center.biz.engine.action.ShotOrderAbstractAction;
import com.qiho.center.common.daoh.qiho.CheckAddressMapper;
import com.qiho.center.common.entityd.qiho.CheckAddressEntity;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class LocationCheckAction
extends ShotOrderAbstractAction {
    @Autowired
    private CheckAddressMapper checkAddressMapper;

    public ResultBase<Boolean> valuteCostomByQuery(OrderSnapshotDto orderSnapshotDto, StrategyRuleDto strategyRuleDto) {
        CheckAddressEntity checkAddressEntity = this.checkAddressMapper.selectByOrderId(orderSnapshotDto.getOrderId());
        if (checkAddressEntity == null) {
            return ResultBase.errorReturn((String)"ip mobile\u5f52\u5c5e\u5730 \u6570\u636e\u672a\u68c0\u6d4b \u89c4\u5219\u65e0\u6cd5\u6821\u9a8c!");
        }
        LocationCheckBean bean = new LocationCheckBean();
        this.dataWrapper(orderSnapshotDto, checkAddressEntity, bean);
        return ShotOrderRuleEnum.fromVal((String)strategyRuleDto.getRuleName()).valuteOrderByQuery(strategyRuleDto.getThreshold(), (Object)bean);
    }

    private void dataWrapper(OrderSnapshotDto orderSnapshotDto, CheckAddressEntity checkAddressEntity, LocationCheckBean bean) {
        if (StringUtils.isNotBlank((CharSequence)orderSnapshotDto.getCity())) {
            bean.setCity(orderSnapshotDto.getCity().substring(0, 2));
        } else {
            bean.setCity("");
        }
        if (StringUtils.isNotBlank((CharSequence)orderSnapshotDto.getProvince())) {
            bean.setProvince(orderSnapshotDto.getProvince().substring(0, 2));
        } else {
            bean.setProvince("");
        }
        String ipCity = checkAddressEntity.getIpCity();
        String ipProvince = checkAddressEntity.getIpProvince();
        if (StringUtils.isNotBlank((CharSequence)ipCity)) {
            bean.setIpCity(ipCity.substring(0, 2));
        } else {
            bean.setIpCity("");
        }
        if (StringUtils.isNotBlank((CharSequence)ipProvince)) {
            bean.setIpProvince(ipProvince.substring(0, 2));
        } else {
            bean.setIpProvince("");
        }
        bean.setMobileCity(checkAddressEntity.getMobileCity());
        bean.setMobileProvince(checkAddressEntity.getMobileProvince());
    }
}

