/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.engine.action;

import com.qiho.center.api.dto.OrderSnapshotDto;
import com.qiho.center.api.dto.StrategyRuleDto;
import com.qiho.center.api.dto.resultbase.ResultBase;
import com.qiho.center.api.enums.ShotOrder.ShotOrderRuleEnum;
import com.qiho.center.api.enums.SmsTypeEnum;
import com.qiho.center.api.enums.ordersms.SmsMobileStatusEnum;
import com.qiho.center.biz.engine.action.ShotOrderAbstractAction;
import com.qiho.center.common.daoh.qiho.ordertmp.BaiqiOrderSmsMapper;
import com.qiho.center.common.entityd.qiho.ordertmp.BaiqiOrderSmsEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class OrderMobileAction
extends ShotOrderAbstractAction {
    private static final Logger logger = LoggerFactory.getLogger(OrderMobileAction.class);
    @Autowired
    private BaiqiOrderSmsMapper baiqiOrderSmsMapper;

    public ResultBase<Boolean> valuteCostomByQuery(OrderSnapshotDto orderSnapshotDto, StrategyRuleDto strategyRuleDto) {
        String threshold = strategyRuleDto.getThreshold();
        BaiqiOrderSmsEntity orderSmsEntity = this.baiqiOrderSmsMapper.findByOrderId(orderSnapshotDto.getOrderId());
        if (null == orderSmsEntity || orderSmsEntity.getSmsType().intValue() != SmsTypeEnum.CHUANG_LAN.getNum()) {
            return ResultBase.rightReturn((Object)false);
        }
        String smsRetCode = SmsMobileStatusEnum.getByNum((int)orderSmsEntity.getMobileStatus()).getCode();
        return ShotOrderRuleEnum.fromVal((String)strategyRuleDto.getRuleName()).valuteOrderByQuery(threshold, (Object)smsRetCode);
    }
}

