/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.engine.action;

import cn.com.duiba.wolf.utils.DateUtils;
import com.qiho.center.api.dto.OrderSnapshotDto;
import com.qiho.center.api.dto.StrategyRuleDto;
import com.qiho.center.api.dto.resultbase.ResultBase;
import com.qiho.center.api.enums.ShotOrder.ShotOrderRuleEnum;
import com.qiho.center.api.enums.ShotOrder.StrategyType;
import com.qiho.center.biz.engine.action.ShotOrderAbstractAction;
import com.qiho.center.common.dao.QihoChannelInfoDAO;
import com.qiho.center.common.daoh.qiho.ordertmp.BaiqiOrderTmpExtMapper;
import com.qiho.center.common.entity.order.QihoChannelInfoEntity;
import com.qiho.center.common.entityd.qiho.ordertmp.BaiqiOrderTmpExtEntity;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepeatOrderTuiacidAction
extends ShotOrderAbstractAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(RepeatOrderTuiacidAction.class);
    @Resource
    private BaiqiOrderTmpExtMapper orderTmpExtMapper;
    @Resource
    private QihoChannelInfoDAO qihoChannelInfoDAO;

    public ResultBase<Boolean> valuteCostomByQuery(OrderSnapshotDto orderSnapshotDto, StrategyRuleDto strategyRuleDto) {
        Map<String, String> map = this.getTuiaCid(orderSnapshotDto);
        String tuiaCid = map.get("tuiaCid");
        if (StringUtils.isEmpty((CharSequence)tuiaCid) || StringUtils.equals((CharSequence)tuiaCid, (CharSequence)Integer.toString(0))) {
            LOGGER.info("\u63a8\u554a\u7528\u6237ID(a_cid)\u4e3a\u7a7a\uff0c\u4e0d\u6821\u9a8c 24\u5c0f\u65f6\u4e0b\u5355\u91cf(\u63a8\u554a\u7528\u6237id\u7edf\u8ba1) \u89c4\u5219!");
            return ResultBase.rightReturn((Object)false);
        }
        int count = this.getCount(tuiaCid);
        return ShotOrderRuleEnum.fromVal((String)strategyRuleDto.getRuleName()).valuteOrderByQuery(strategyRuleDto.getThreshold(), (Object)count);
    }

    private int getCount(String tuiaCid) {
        Date startTime = DateUtils.daysAddOrSub((Date)new Date(), (int)-1);
        QihoChannelInfoEntity params = new QihoChannelInfoEntity();
        params.setStartTime(startTime);
        params.setTuiaCid(tuiaCid);
        List channelInfoEntityList = this.qihoChannelInfoDAO.countByParams(params);
        if (CollectionUtils.isEmpty((Collection)channelInfoEntityList)) {
            return -1;
        }
        return channelInfoEntityList.size();
    }

    private Map<String, String> getTuiaCid(OrderSnapshotDto orderSnapshotDto) {
        String tuiaCid;
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtils.isNotEmpty((CharSequence)orderSnapshotDto.getOrderId())) {
            BaiqiOrderTmpExtEntity orderTmpExtEntity = this.orderTmpExtMapper.findByOrderId(orderSnapshotDto.getOrderId());
            if (null != orderTmpExtEntity) {
                tuiaCid = orderTmpExtEntity.getTuiaCid();
                map.put("strategyType", StrategyType.FILTER_ORDER_RULE.getValue());
            } else {
                tuiaCid = this.qihoChannelInfoDAO.findByOrderId(orderSnapshotDto.getOrderId()).getTuiaCid();
                map.put("strategyType", StrategyType.SHOT_ORDER.getValue());
            }
        } else {
            tuiaCid = orderSnapshotDto.getTuiaCid();
            map.put("strategyType", StrategyType.AHEAD_PREVENT_ORDER.getValue());
        }
        map.put("tuiaCid", tuiaCid);
        return map;
    }
}

