/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.engine.impl;

import com.alibaba.fastjson.JSONObject;
import com.qiho.center.api.dto.OrderSnapshotDto;
import com.qiho.center.api.dto.OrderStrategyDto;
import com.qiho.center.api.dto.StrategyCheckResultDto;
import com.qiho.center.api.dto.StrategyRuleDto;
import com.qiho.center.api.dto.resultbase.ResultBase;
import com.qiho.center.api.enums.ShotOrder.ShotOrderHandlerEnum;
import com.qiho.center.api.enums.ShotOrder.StrategyType;
import com.qiho.center.api.enums.StrategyUseType;
import com.qiho.center.biz.engine.BaseEngine;
import com.qiho.center.biz.engine.BaseHandler;
import com.qiho.center.biz.engine.Factory.ProcessFaceory;
import com.qiho.center.biz.engine.ProcessContext;
import com.qiho.center.biz.engine.impl.BaseOrderEngine;
import com.qiho.center.biz.service.order.StrategyMerchantService;
import com.qiho.center.common.entityd.qiho.order.StrategyMerchantEntity;
import com.qiho.center.common.enums.InnerLogTypeEnum;
import com.qiho.center.common.log.InnerLog;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class AheadPreventOrderEngine
extends BaseOrderEngine
implements BaseEngine<StrategyCheckResultDto> {
    private Logger logger = LoggerFactory.getLogger(AheadPreventOrderEngine.class);
    private BaseHandler baseHandler;
    @Autowired
    private StrategyMerchantService strategyMerchantService;

    @Override
    public StrategyCheckResultDto process(StrategyCheckResultDto result) {
        if (null == result || null == result.getOrderSnapshotDto()) {
            return result;
        }
        result.setSuccess(true);
        try {
            List<OrderStrategyDto> orderStrategyDtos = this.getOrderStrategyList(StrategyType.AHEAD_PREVENT_ORDER);
            if (CollectionUtils.isEmpty(orderStrategyDtos)) {
                return result;
            }
            return this.checkStrategy(result, orderStrategyDtos);
        }
        catch (Exception e) {
            this.logger.error("\u7b56\u7565\u8fc7\u6ee4\u94fe\u8def\u5931\u8d25, data={}", (Object)result.toString(), (Object)e);
            return result;
        }
    }

    private StrategyCheckResultDto checkStrategy(StrategyCheckResultDto result, List<OrderStrategyDto> orderStrategyDtos) {
        for (OrderStrategyDto orderStrategyDto : orderStrategyDtos) {
            Boolean match = this.isOrderMatchStrategy(orderStrategyDto, result.getOrderSnapshotDto());
            if (!match.booleanValue()) continue;
            Boolean flag = Boolean.TRUE;
            ResultBase<List<StrategyRuleDto>> resultBase = this.validateorderStrategyDto(orderStrategyDto);
            if (!resultBase.hasSuccessValue()) {
                this.logger.warn(resultBase.getErrorMsg());
                continue;
            }
            List strategyRuleDtos = (List)resultBase.getValue();
            ResultBase<Boolean> checkResult = null;
            for (StrategyRuleDto strategyRuleDto : strategyRuleDtos) {
                ProcessContext processContext = this.createProcessContext(result, orderStrategyDto, strategyRuleDto);
                checkResult = this.baseHandler.handleRequest(processContext);
                if (checkResult.hasSuccessValue()) {
                    flag = flag != false && (Boolean)checkResult.getValue() != false;
                    continue;
                }
                flag = Boolean.FALSE;
                this.logger.warn("\u672c\u6761\u7b56\u7565\u89c4\u5219\u6821\u9a8c\u5931\u8d25 msg={} strategyName={} ruleName={} fieldName={}", new Object[]{checkResult.getErrorMsg(), orderStrategyDto.getStrategyName(), strategyRuleDto.getRuleName(), strategyRuleDto.getFieldName()});
                break;
            }
            if (!flag.booleanValue()) continue;
            return this.packageResult(result, orderStrategyDto, checkResult);
        }
        return result;
    }

    private StrategyCheckResultDto packageResult(StrategyCheckResultDto result, OrderStrategyDto orderStrategyDto, ResultBase<Boolean> checkResult) {
        JSONObject logInfo = new JSONObject();
        logInfo.put("order", (Object)result.getOrderSnapshotDto());
        logInfo.put("rule", (Object)orderStrategyDto);
        InnerLog.log((InnerLogTypeEnum)InnerLogTypeEnum.SUBMIT_ORDER_RULE, (Object)logInfo);
        result.setSuccess(false);
        result.setShotOrderHandlerEnum(ShotOrderHandlerEnum.fromVal((String)orderStrategyDto.getHandlerName()));
        result.setShotOrderField(checkResult == null ? null : checkResult.getHitField());
        return result;
    }

    private ProcessContext createProcessContext(StrategyCheckResultDto result, OrderStrategyDto orderStrategyDto, StrategyRuleDto strategyRuleDto) {
        if (StrategyUseType.PART.equals((Object)StrategyUseType.findByValue((int)orderStrategyDto.getUseType()))) {
            strategyRuleDto.setPartMerchant(Boolean.valueOf(true));
        } else {
            strategyRuleDto.setPartMerchant(Boolean.valueOf(false));
        }
        return ProcessFaceory.createProcessContext(result.getOrderSnapshotDto(), strategyRuleDto, orderStrategyDto);
    }

    private boolean isOrderMatchStrategy(OrderStrategyDto orderStrategyDto, OrderSnapshotDto orderSnapshotDto) {
        StrategyUseType useType = StrategyUseType.findByValue((int)orderStrategyDto.getUseType());
        if (StrategyUseType.PART.equals((Object)useType)) {
            Long strategyId;
            Long merchantId = orderSnapshotDto.getMerchantId();
            StrategyMerchantEntity strategyMerchantEntity = this.strategyMerchantService.find(merchantId, strategyId = orderStrategyDto.getId());
            return strategyMerchantEntity != null;
        }
        return true;
    }

    public BaseHandler getBaseHandler() {
        return this.baseHandler;
    }

    public void setBaseHandler(BaseHandler baseHandler) {
        this.baseHandler = baseHandler;
    }

    public StrategyMerchantService getStrategyMerchantService() {
        return this.strategyMerchantService;
    }

    public void setStrategyMerchantService(StrategyMerchantService strategyMerchantService) {
        this.strategyMerchantService = strategyMerchantService;
    }
}

